import { DeviceSettingsValue } from '../DeviceSettings';
import { Validation, ValidationOutput } from '../../../Validation/Validation';
import { DeviceSettingsType } from '../DeviceSettingsType';
type TimerSettings = DeviceSettingsValue<DeviceSettingsType.TIMERS>[number];
type ProprietaryTimerSettings = DeviceSettingsValue<DeviceSettingsType.PROPRIETARY_TIMERS>[number];
export declare const validNativeKeys: {
    [K in keyof Required<TimerSettings>]: true;
};
export declare const validProprietaryKeys: {
    [K in keyof Required<ProprietaryTimerSettings>]: true;
};
export default function validateTimerSettings(settings: unknown): ValidationOutput<TimerSettings>;
export declare function validateProprietaryTimerSettings(settings: unknown): ValidationOutput<ProprietaryTimerSettings>;
export declare function validateCommonTimerSettings<T extends TimerSettings | ProprietaryTimerSettings>(settings: unknown): Validation<T>;
export declare class InvalidTimerType extends Error {
    constructor(type: unknown);
}
export declare class InvalidTimerTimeOn extends Error {
    constructor(timeOn: unknown);
}
export declare class InvalidTimerTimeOff extends Error {
    constructor(timeOff: unknown);
}
export declare class InvalidTimerVolume extends Error {
    constructor(volume: unknown);
}
export {};
