"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidPowerActionScheduleUid = exports.InvalidPowerActionScheduleTime = exports.InvalidPowerType = exports.validKeys = void 0;
exports.default = validatePowerActionScheduleSettings;
const PowerActionType_1 = require("../../Power/PowerActionType");
const validateWeekdays_1 = require("../../Time/Validation/validateWeekdays");
const isValidTime_1 = require("../../Time/Validation/isValidTime");
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    powerType: true,
    time: true,
    uid: true,
    weekdays: true,
};
function validatePowerActionScheduleSettings(settings) {
    var _a;
    const { powerType, weekdays, time, uid } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notValidPowerType = !(typeof powerType === 'string' && powerType in PowerActionType_1.default);
    const notValidTime = !(0, isValidTime_1.default)(time);
    const notValidUid = !(typeof uid === 'string' && uid.length > 0);
    const weekdaysValidation = (0, validateWeekdays_1.default)(weekdays);
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notValidPowerType) {
        validation.addError(new InvalidPowerType(powerType));
    }
    if (notValidTime) {
        validation.addError(new InvalidPowerActionScheduleTime(time));
    }
    if (notValidUid) {
        validation.addError(new InvalidPowerActionScheduleUid(uid));
    }
    validation.addError(...weekdaysValidation.getErrors());
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
class InvalidPowerType extends Error {
    constructor(type) {
        super(`Power Action Schedule Settings Action Type is not valid: ${type}`);
    }
}
exports.InvalidPowerType = InvalidPowerType;
class InvalidPowerActionScheduleTime extends Error {
    constructor(time) {
        super(`Power Action Schedule Settings Time is not valid (HH:mm): ${time}`);
    }
}
exports.InvalidPowerActionScheduleTime = InvalidPowerActionScheduleTime;
class InvalidPowerActionScheduleUid extends Error {
    constructor(uid) {
        super(`Power Action Schedule Settings Uid is not valid: ${uid}`);
    }
}
exports.InvalidPowerActionScheduleUid = InvalidPowerActionScheduleUid;
