import { DeviceSettingsValue } from '../DeviceSettings';
import { ValidationOutput } from '../../../Validation/Validation';
import { DeviceSettingsType } from '../DeviceSettingsType';
type AutoRecoverySettings = DeviceSettingsValue<DeviceSettingsType.AUTO_RECOVERY>;
export declare const validKeys: {
    [K in keyof Required<AutoRecoverySettings>]: true;
};
export default function validateAutoRecoverySettings(settings: unknown): ValidationOutput<AutoRecoverySettings>;
export declare class InvalidAutoRecoverySettingsEnabled extends Error {
    constructor(enabled: unknown);
}
export declare class InvalidAutoRecoverySettingsHealthcheckIntervalMs extends Error {
    constructor(healthcheckIntervalMs: unknown);
}
export declare class InvalidAutoRecoverySettingsAutoEnableTimeoutMs extends Error {
    constructor(autoEnableTimeoutMs: unknown);
}
export {};
