"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyEventTypes = exports.ButtonEventTypes = exports.MouseEventTypes = exports.FromBrowserMessages = exports.FromDeviceMessages = exports.Message = void 0;
var Message;
(function (Message) {
    // Messages from device to browser
    Message["ScreenshotRecorded"] = "ScreenshotRecorded";
    // Messages from browser to device
    Message["MouseEvent"] = "MouseEvent";
    Message["KeyEvent"] = "KeyEvent";
    Message["ButtonEvent"] = "ButtonEvent";
    // General server control messages
    Message["BrowserConnected"] = "BrowserConnected";
    Message["BrowserDisconnected"] = "BrowserDisconnected";
    Message["DeviceConnected"] = "DeviceConnected";
    Message["DeviceDisconnected"] = "DeviceDisconnected";
})(Message || (exports.Message = Message = {}));
exports.FromDeviceMessages = [Message.ScreenshotRecorded];
exports.FromBrowserMessages = [Message.MouseEvent, Message.KeyEvent, Message.ButtonEvent];
exports.MouseEventTypes = ['mousedown', 'mouseup', 'click', 'dblclick', 'mousemove', 'cancel'];
exports.ButtonEventTypes = ['up', 'down', 'left', 'right', 'back', 'home', 'recentapps', 'accept'];
exports.KeyEventTypes = ['down', 'up'];
