import { z } from 'zod';
export declare const AndroidDevicePackageUninstallationSchema: z.ZodObject<z.objectUtil.extendShape<{
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
    /**
     * Proprietary package name (platform independent)
     */
    packageName: z.ZodString;
    /**
     * Platform specific information differs for each application type
     */
    specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
}, {
    applicationType: z.ZodLiteral<"android">;
    specs: z.ZodObject<{
        packageName: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
    }, {
        packageName: string;
    }>;
}>, "strict", z.ZodTypeAny, {
    packageName: string;
    applicationType: "android";
    specs: {
        packageName: string;
    };
}, {
    packageName: string;
    applicationType: "android";
    specs: {
        packageName: string;
    };
}>;
export type AndroidDevicePackageUninstallation = z.infer<typeof AndroidDevicePackageUninstallationSchema>;
export declare const DevicePackageUninstallationSchema: z.ZodObject<z.objectUtil.extendShape<{
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
    /**
     * Proprietary package name (platform independent)
     */
    packageName: z.ZodString;
    /**
     * Platform specific information differs for each application type
     */
    specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
}, {
    applicationType: z.ZodLiteral<"android">;
    specs: z.ZodObject<{
        packageName: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
    }, {
        packageName: string;
    }>;
}>, "strict", z.ZodTypeAny, {
    packageName: string;
    applicationType: "android";
    specs: {
        packageName: string;
    };
}, {
    packageName: string;
    applicationType: "android";
    specs: {
        packageName: string;
    };
}>;
export type DevicePackageUninstallation = z.infer<typeof DevicePackageUninstallationSchema>;
