import { z } from 'zod';
export declare const TizenDevicePackageInstallationFromUriSchema: z.ZodObject<z.objectUtil.extendShape<{
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
    /** Direct URI to package file */
    packageUri: z.ZodString;
    specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
}, {
    applicationType: z.ZodLiteral<"tizen">;
    /** Tizen doesn't require any additional specs */
    specs: z.ZodOptional<z.ZodNever>;
}>, "strict", z.ZodTypeAny, {
    applicationType: "tizen";
    packageUri: string;
    specs?: undefined;
}, {
    applicationType: "tizen";
    packageUri: string;
    specs?: undefined;
}>;
export type TizenDevicePackageInstallationFromUri = z.infer<typeof TizenDevicePackageInstallationFromUriSchema>;
export declare const AndroidDevicePackageInstallationFromUriSchema: z.ZodObject<z.objectUtil.extendShape<{
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
    /** Direct URI to package file */
    packageUri: z.ZodString;
    specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
}, {
    applicationType: z.ZodLiteral<"android">;
    /**
     * Platform specific information differs for each application type.
     * Contains unique hash (usually checksum of package file) which is unique for every build.
     * Core App will validate the checksum before package is installed and fail if doesn't match.
     * If specs are not provided, Core App will install the package without validation.
     */
    specs: z.ZodOptional<z.ZodObject<{
        packageName: z.ZodString;
        apkSha256: z.ZodOptional<z.ZodString>;
        signatureSha256: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }>>;
}>, "strict", z.ZodTypeAny, {
    applicationType: "android";
    packageUri: string;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}, {
    applicationType: "android";
    packageUri: string;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}>;
export type AndroidDevicePackageInstallationFromUri = z.infer<typeof AndroidDevicePackageInstallationFromUriSchema>;
export declare const DevicePackageInstallationFromUriSchema: z.ZodDiscriminatedUnion<"applicationType", [z.ZodObject<z.objectUtil.extendShape<{
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
    /** Direct URI to package file */
    packageUri: z.ZodString;
    specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
}, {
    applicationType: z.ZodLiteral<"android">;
    /**
     * Platform specific information differs for each application type.
     * Contains unique hash (usually checksum of package file) which is unique for every build.
     * Core App will validate the checksum before package is installed and fail if doesn't match.
     * If specs are not provided, Core App will install the package without validation.
     */
    specs: z.ZodOptional<z.ZodObject<{
        packageName: z.ZodString;
        apkSha256: z.ZodOptional<z.ZodString>;
        signatureSha256: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }>>;
}>, "strict", z.ZodTypeAny, {
    applicationType: "android";
    packageUri: string;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}, {
    applicationType: "android";
    packageUri: string;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
    /** Direct URI to package file */
    packageUri: z.ZodString;
    specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
}, {
    applicationType: z.ZodLiteral<"tizen">;
    /** Tizen doesn't require any additional specs */
    specs: z.ZodOptional<z.ZodNever>;
}>, "strict", z.ZodTypeAny, {
    applicationType: "tizen";
    packageUri: string;
    specs?: undefined;
}, {
    applicationType: "tizen";
    packageUri: string;
    specs?: undefined;
}>]>;
export type DevicePackageInstallationFromUri = z.infer<typeof DevicePackageInstallationFromUriSchema>;
