import { z } from 'zod';
export declare const SCRIPT_MAX_LENGTH = 10000;
export declare const DangerLevelSchema: z.ZodEnum<["low", "medium", "high", "critical"]>;
export type DangerLevel = z.infer<typeof DangerLevelSchema>;
export declare const RuntimeSchema: z.ZodEnum<["ps1", "bash", "sh", "nodejs", "browser", "brs"]>;
export type Runtime = z.infer<typeof RuntimeSchema>;
declare const InlineCustomScriptSchema: z.ZodObject<{
    runtime: z.ZodEnum<["ps1", "bash", "sh", "nodejs", "browser", "brs"]>;
    /** The script content */
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
}, {
    script: string;
    runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
}>;
declare const ArchiveCustomScriptSchema: z.ZodObject<{
    runtime: z.ZodEnum<["ps1", "bash", "sh", "nodejs", "browser", "brs"]>;
    /** URI to download code archive */
    archiveUri: z.ZodString;
    /** MD5 checksum of the archive */
    md5Checksum: z.ZodString;
    /** The entry point of the script */
    mainFile: z.ZodString;
}, "strict", z.ZodTypeAny, {
    runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
    archiveUri: string;
    md5Checksum: string;
    mainFile: string;
}, {
    runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
    archiveUri: string;
    md5Checksum: string;
    mainFile: string;
}>;
export declare const CustomScriptSchema: z.ZodUnion<[z.ZodObject<{
    runtime: z.ZodEnum<["ps1", "bash", "sh", "nodejs", "browser", "brs"]>;
    /** The script content */
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
}, {
    script: string;
    runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
}>, z.ZodObject<{
    runtime: z.ZodEnum<["ps1", "bash", "sh", "nodejs", "browser", "brs"]>;
    /** URI to download code archive */
    archiveUri: z.ZodString;
    /** MD5 checksum of the archive */
    md5Checksum: z.ZodString;
    /** The entry point of the script */
    mainFile: z.ZodString;
}, "strict", z.ZodTypeAny, {
    runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
    archiveUri: string;
    md5Checksum: string;
    mainFile: string;
}, {
    runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
    archiveUri: string;
    md5Checksum: string;
    mainFile: string;
}>]>;
export type CustomScript = z.infer<typeof CustomScriptSchema>;
export type InlineCustomScript = z.infer<typeof InlineCustomScriptSchema>;
export type ArchiveCustomScript = z.infer<typeof ArchiveCustomScriptSchema>;
export declare function isInlineCustomScript(script: CustomScript): script is InlineCustomScript;
export declare function isArchiveCustomScript(script: CustomScript): script is ArchiveCustomScript;
/**
 * @see https://learn.microsoft.com/en-us/powershell/module/microsoft.powershell.utility/write-output?view=powershell-7.4
 */
export declare const ResultStreamPipelineSchema: z.ZodEnum<["error", "output"]>;
export declare const CustomScriptResultSchema: z.ZodObject<{
    runtime: z.ZodEnum<["ps1", "bash", "sh", "nodejs", "browser", "brs"]>;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
    exitCode: number;
}>;
export type CustomScriptResult = z.infer<typeof CustomScriptResultSchema>;
export {};
