/**
 * Module to generate seed based random numbers.
 */
export declare class Mersenne {
    private gen;
    constructor();
    /**
     * Generates a random number between `[min, max)`.
     *
     * @param max The maximum number. Defaults to `0`.
     * @param min The minimum number. Defaults to `32768`.
     *
     * @example
     * faker.mersenne.rand() // 15515
     * faker.mersenne.rand(500, 1000) // 578
     */
    rand(max?: number, min?: number): number;
    /**
     * Sets the seed to use.
     *
     * @param S The seed to use.
     * @throws If the seed is not a `number`.
     */
    seed(S: number): void;
    /**
     * Sets the seed to use.
     *
     * @param A The seed to use.
     * @throws If the seed is not a `number[]`.
     */
    seed_array(A: number[]): void;
}
