"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepareSchema = exports.recreateSchema = void 0;
const domainModel_1 = require("../Mongo/EventSourcing/domainModel");
const consumedEventModel_1 = require("../Mongo/EventSourcing/consumedEventModel");
const deviceModel_1 = require("../Mongo/Device/deviceModel");
const deviceConfigurationModel_1 = require("../Mongo/Device/Configuration/deviceConfigurationModel");
const deviceInfoModel_1 = require("../Mongo/Device/Info/deviceInfoModel");
const devicePowerActionModel_1 = require("../Mongo/Device/PowerAction/devicePowerActionModel");
const deviceMonitoringLogLatestModel_1 = require("../Mongo/Device/MonitoringLog/deviceMonitoringLogLatestModel");
const deviceCounterModel_1 = require("../Mongo/Device/Counter/deviceCounterModel");
const devicePolicyStatusModel_1 = require("../Mongo/Device/PolicyStatus/devicePolicyStatusModel");
const deviceHourlyConnectedStatusModel_1 = require("../Mongo/Device/Monitoring/deviceHourlyConnectedStatusModel");
const deviceReportFileModel_1 = require("../Mongo/Device/Report/deviceReportFileModel");
const deviceScreenshotModel_1 = require("../Mongo/Device/Screenshot/deviceScreenshotModel");
const deviceTemperatureModel_1 = require("../Mongo/Device/Temperature/deviceTemperatureModel");
const deviceSessionModel_1 = require("../Mongo/Device/Session/deviceSessionModel");
const timingCommandModel_1 = require("../Mongo/Timing/Command/timingCommandModel");
const systemLogModel_1 = require("../Mongo/SystemLog/systemLogModel");
const applicationVersionBuildRequestModel_1 = require("../Mongo/Application/Version/applicationVersionBuildRequestModel");
const accountModel_1 = require("../Mongo/Account/accountModel");
const organizationModel_1 = require("../Mongo/Organization/organizationModel");
const organizationDetailsModel_1 = require("../Mongo/Organization/organizationDetailsModel");
const frontDisplayVersionModel_1 = require("../Mongo/FrontDisplay/Version/frontDisplayVersionModel");
const applicationVersionModel_1 = require("../Mongo/Application/Version/applicationVersionModel");
const deviceVerificationModel_1 = require("../Mongo/Device/Verification/deviceVerificationModel");
const deviceNoteModel_1 = require("../Mongo/Device/Note/deviceNoteModel");
const organizationTagModel_1 = require("../Mongo/Organization/Tag/organizationTagModel");
const devicePackageStartModel_1 = require("../Mongo/Device/Package/devicePackageStartModel");
const deviceInstalledPackageModel_1 = require("../Mongo/Device/Package/deviceInstalledPackageModel");
const deviceActionLogModel_1 = require("../Mongo/Device/ActionLog/deviceActionLogModel");
const appletModel_1 = require("../Mongo/Applet/appletModel");
const appletVersionModel_1 = require("../Mongo/Applet/appletVersionModel");
const accountSettingsModel_1 = require("../Mongo/Account/accountSettingsModel");
const packageModel_1 = require("../Mongo/Package/packageModel");
const packageVersionModel_1 = require("../Mongo/Package/packageVersionModel");
const serverInstanceModel_1 = require("../Mongo/ServerInstance/serverInstanceModel");
const issuedDeviceLicenseModel_1 = require("../Mongo/License/issuedDeviceLicenseModel");
const issuedServerLicenseModel_1 = require("../Mongo/License/issuedServerLicenseModel");
const issuedServerLicenseValidityModel_1 = require("../Mongo/License/issuedServerLicenseValidityModel");
const frontAppletVersionModel_1 = require("../Mongo/FrontApplet/Version/frontAppletVersionModel");
const ownServerLicenseModel_1 = require("../Mongo/License/ownServerLicenseModel");
const ownServerLicenseValidityModel_1 = require("../Mongo/License/ownServerLicenseValidityModel");
const firmwareVersionModel_1 = require("../Mongo/Firmware/firmwareVersionModel");
const timingModel_1 = require("../Mongo/Timing/timingModel");
const deviceTestModel_1 = require("../Mongo/Device/Test/deviceTestModel");
const deviceAppletTestModel_1 = require("../Mongo/Device/Applet/deviceAppletTestModel");
const deviceTimerModel_1 = require("../Mongo/Device/Timer/deviceTimerModel");
const appletTestSuiteModel_1 = require("../Mongo/Applet/appletTestSuiteModel");
const deviceAuthenticationModel_1 = require("../Mongo/Device/Authentication/deviceAuthenticationModel");
const termsModel_1 = require("../Mongo/Terms/termsModel");
const deviceExportLogModel_1 = require("../Mongo/Device/Log/deviceExportLogModel");
const organizationStatisticsModel_1 = require("../Mongo/Organization/organizationStatisticsModel");
const packageVersionNoteModel_1 = require("../Mongo/Package/packageVersionNoteModel");
const policyLogModel_1 = require("../Mongo/Policy/policyLogModel");
const alertModel_1 = require("../Mongo/Alert/alertModel");
const alertRuleModel_1 = require("../Mongo/Alert/alertRuleModel");
const apiRequestModel_1 = require("../Mongo/Request/apiRequestModel");
const bulkOperationModel_1 = require("../Mongo/BulkOperation/bulkOperationModel");
const bulkRequestedEventModel_1 = require("../Mongo/BulkOperation/bulkRequestedEventModel");
const locationModel_1 = require("../Mongo/Location/locationModel");
const deviceMonitoringLogFullModel_1 = require("../Mongo/Device/MonitoringLog/deviceMonitoringLogFullModel");
const uiThemeModel_1 = require("../Mongo/UITheme/uiThemeModel");
const whiteLabelSettingsModel_1 = require("../Mongo/WhiteLabelSettings/whiteLabelSettingsModel");
const companyNetworkModel_1 = require("../Mongo/CompanyNetwork/companyNetworkModel");
const termsAndConditionsModel_1 = require("../Mongo/TermsAndConditions/termsAndConditionsModel");
const termsAndConditionsVersionModel_1 = require("../Mongo/TermsAndConditionsVersion/termsAndConditionsVersionModel");
const policyModel_1 = require("../Mongo/Policy/policyModel");
const deviceProvisioningRecipeModel_1 = require("../Mongo/Device/ProvisioningRecipe/deviceProvisioningRecipeModel");
const thirdPartyCredentialsModel_1 = require("../Mongo/ThirdPartyCredentials/thirdPartyCredentialsModel");
const tablePreparers = [
    domainModel_1.prepareDomainTable,
    consumedEventModel_1.prepareConsumedEventTable,
    accountModel_1.prepareAccountTable,
    accountSettingsModel_1.prepareAccountSettingsTable,
    appletModel_1.prepareAppletTable,
    appletVersionModel_1.prepareAppletVersionTable,
    appletTestSuiteModel_1.prepareAppletTestSuiteTable,
    deviceModel_1.prepareDeviceTable,
    deviceConfigurationModel_1.prepareDeviceConfigurationTable,
    deviceInfoModel_1.prepareDeviceInfoTable,
    devicePowerActionModel_1.prepareDevicePowerActionTable,
    deviceMonitoringLogFullModel_1.prepareDeviceMonitoringLogFullTable,
    deviceMonitoringLogLatestModel_1.prepareDeviceMonitoringLogLatestTable,
    deviceCounterModel_1.prepareDeviceCounterScreenshotTable,
    deviceCounterModel_1.prepareDeviceCounterFailedActionTable,
    devicePolicyStatusModel_1.prepareDevicePolicyStatusTable,
    deviceTimerModel_1.prepareDeviceTimerTable,
    deviceHourlyConnectedStatusModel_1.prepareDeviceHourlyConnectedStatusTable,
    deviceReportFileModel_1.prepareDeviceReportFileTable,
    deviceScreenshotModel_1.prepareDeviceScreenshotTable,
    deviceTemperatureModel_1.prepareDeviceTemperatureTable,
    deviceVerificationModel_1.prepareDeviceVerificationTable,
    deviceNoteModel_1.prepareDeviceNoteTable,
    devicePackageStartModel_1.prepareDevicePackageStartTable,
    deviceInstalledPackageModel_1.prepareDeviceInstalledPackageTable,
    deviceActionLogModel_1.prepareDeviceActionLogTable,
    deviceProvisioningRecipeModel_1.prepareDeviceProvisioningRecipeTable,
    deviceSessionModel_1.prepareDeviceSessionTable,
    timingCommandModel_1.prepareTimingCommandTable,
    systemLogModel_1.prepareSystemLogTable,
    applicationVersionModel_1.prepareApplicationVersionTable,
    applicationVersionBuildRequestModel_1.prepareApplicationVersionBuildRequestTable,
    organizationModel_1.prepareOrganizationTable,
    organizationDetailsModel_1.prepareOrganizationDetailsTable,
    organizationTagModel_1.prepareOrganizationTagTable,
    organizationStatisticsModel_1.prepareOrganizationStatisticsTable,
    policyLogModel_1.preparePolicyLogTable,
    policyModel_1.preparePolicyTable,
    frontAppletVersionModel_1.prepareFrontAppletVersionTable,
    frontDisplayVersionModel_1.prepareFrontDisplayVersionTable,
    packageModel_1.preparePackageTable,
    packageVersionModel_1.preparePackageVersionTable,
    serverInstanceModel_1.prepareServerInstanceTable,
    issuedDeviceLicenseModel_1.prepareIssuedDeviceLicenseTable,
    issuedServerLicenseModel_1.prepareIssuedServerLicenseTable,
    issuedServerLicenseValidityModel_1.prepareIssuedServerLicenseValidityTable,
    ownServerLicenseModel_1.prepareOwnServerLicenseTable,
    ownServerLicenseValidityModel_1.prepareOwnServerLicenseValidityTable,
    firmwareVersionModel_1.prepareFirmwareVersionTable,
    timingModel_1.prepareTimingTable,
    deviceTestModel_1.prepareDeviceTestTable,
    deviceAppletTestModel_1.prepareDeviceAppletTestTable,
    deviceAuthenticationModel_1.prepareDeviceAuthenticationTable,
    termsModel_1.prepareTermsAgreementTable,
    termsModel_1.prepareTermsExceptionTable,
    deviceExportLogModel_1.prepareDeviceExportLogTable,
    packageVersionNoteModel_1.preparePackageVersionNoteTable,
    alertModel_1.prepareAlertTable,
    alertRuleModel_1.prepareAlertRuleTable,
    apiRequestModel_1.prepareRequestTable,
    bulkOperationModel_1.prepareBulkOperationTable,
    bulkRequestedEventModel_1.prepareBulkRequestedEventTable,
    locationModel_1.prepareLocationTable,
    uiThemeModel_1.prepareUIThemeTable,
    whiteLabelSettingsModel_1.prepareWhiteLabelSettingsTable,
    companyNetworkModel_1.prepareCompanyNetworkTable,
    termsAndConditionsModel_1.prepareTermsAndConditionsTable,
    termsAndConditionsVersionModel_1.prepareTermsAndConditionsVersionTable,
    thirdPartyCredentialsModel_1.prepareThirdPartyCredentialsTable,
];
function recreateSchema(mongodbConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        const collections = yield mongodbConnection.connection.getClient().db().collections();
        for (const collection of collections) {
            if (!collection.collectionName.startsWith('system.')) {
                yield collection.deleteMany({});
            }
            // uncomment if indexes were changed (i.e after rebase) - enough to run only once
            // await collection.dropIndexes();
        }
        yield prepareSchema(mongodbConnection);
    });
}
exports.recreateSchema = recreateSchema;
function prepareSchema(mongodbConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        for (const tablePreparer of tablePreparers) {
            yield tablePreparer(mongodbConnection);
        }
    });
}
exports.prepareSchema = prepareSchema;
//# sourceMappingURL=schema.js.map