/// <reference types="lib.es2017.observable" />
import { IApplet } from '../Applet/appletModel';
import { IDevice, IDeviceIdentification } from '../Device/deviceModel';
import IChanges from '../../IChanges';
import { OffsetPagination, Sorting } from '../../Lib/Pagination/paginationTypes';
export declare type TimingSortField = 'createdAt' | 'updatedAt' | 'startsAt' | 'endsAt' | 'deviceIdentityHash';
export interface ITiming {
    uid: string;
    appletUid: string;
    deviceIdentityHash: string;
    createdAt: Date;
    updatedAt: Date;
    /** @deprecated use `active` instead; this field only kept for BC and will be removed in the future */
    startsAt: Date;
    /** @deprecated use `active` instead; this field only kept for BC and will be removed in the future */
    endsAt: Date;
    configuration: object;
    appletVersion: string;
    /** @deprecated use `active` instead; this field only kept for BC and will be removed in the future */
    finishEvent: {
        type: string;
        data?: any;
    };
    /** @deprecated use `active` instead; this field only kept for BC and will be removed in the future */
    position: number;
    active: boolean;
}
export declare type TimingCreateValues = Pick<ITiming, 'uid' | 'configuration' | 'appletVersion' | 'createdAt' | 'startsAt' | 'endsAt' | 'finishEvent' | 'position' | 'active'>;
export declare type TimingUpdateValues = Pick<ITiming, 'updatedAt'> & Partial<Pick<ITiming, 'configuration' | 'appletVersion' | 'startsAt' | 'endsAt' | 'finishEvent' | 'position' | 'active'>>;
export interface FetchListArgs {
    /** Filter timings of particular devices */
    devices?: IDeviceIdentification[];
    /** Filter timings of a particular applet */
    applet?: IApplet;
    /** Filter timings by active status */
    active?: boolean;
    pagination?: OffsetPagination;
    sorting?: Sorting<TimingSortField>;
}
export interface CountArgs {
    /** Filter timings of a particular applet */
    applet: IApplet;
}
export declare type ITimingModel<TTiming extends ITiming> = ITimingModelRequired<TTiming> | (ITimingModelRequired<TTiming> & ITimingModelObservable<TTiming>);
export declare type ITimingIdentification = Pick<ITiming, 'uid' | 'deviceIdentityHash'>;
export interface ITimingModelRequired<TTiming extends ITiming> {
    fetchByUid(uid: string): Promise<TTiming | null>;
    fetchList(args: FetchListArgs): Promise<TTiming[]>;
    count(args: CountArgs): Promise<number>;
    create(appletRow: Pick<IApplet, 'uid'>, deviceRow: IDevice, values: TimingCreateValues): Promise<void>;
    update(timingRow: ITimingIdentification, values: TimingUpdateValues): Promise<void>;
    remove(timingRow: ITimingIdentification): Promise<void>;
}
export interface ITimingModelObservable<T extends ITiming> {
    observeListByDevice(device: IDevice): Promise<Observable<ITiming[], Error>>;
    observeByUid(timingUid: string): Promise<Observable<IChanges<T>, Error>>;
}
//# sourceMappingURL=timingModel.d.ts.map