import { Optional } from 'utility-types';
import { OffsetPagination, Sorting } from '../../../Lib/Pagination/paginationTypes';
import { IDevice } from '../../Device/deviceModel';
export declare type TimingCommandSortField = 'receivedAt' | 'recordedAt';
export interface ITimingCommandPropertyFilter {
    appletUid?: string;
    type?: string;
    excludeType?: string;
    /**
     * This field is intended for filtering based on commandPayload properties.
     * Use it judiciously, as the values are not indexed and may result in performance issues.
     */
    payloadKeyValue?: Omit<ICommandPayload, 'type'>;
    receivedSince?: Date;
    receivedUntil?: Date;
    recordedSince?: Date;
    recordedUntil?: Date;
}
export interface ICommandPayload {
    type: string;
    [payloadKey: string]: any;
}
export interface ITimingCommand {
    id: string;
    commandPayload: ICommandPayload;
    deviceIdentityHash: string;
    appletUid: string;
    timingChecksum: string | null;
    /** Server time when the log was received */
    receivedAt: Date;
    /** Device time when the log was recorded */
    recordedAt: Date;
}
export interface IUniqueTypesParams {
    device: IDevice;
    receivedSince?: Date;
    receivedUntil?: Date;
    recordedSince?: Date;
    recordedUntil?: Date;
}
export declare type ICreateTimingCommandArg = Optional<ITimingCommand, 'id'>;
export interface ITimingCommandModel {
    fetchById(id: string): Promise<ITimingCommand | null>;
    fetchListByDeviceAndPropertyFilter(device: IDevice, propertyFilter: ITimingCommandPropertyFilter, pagination?: OffsetPagination, customSorting?: Sorting<TimingCommandSortField>): Promise<ITimingCommand[]>;
    fetchUniqueTypesByDevice(params: IUniqueTypesParams): Promise<ICommandPayload['type'][]>;
    countByDeviceAndPropertyFilter(device: IDevice, propertyFilter: ITimingCommandPropertyFilter): Promise<number>;
    create(timingCommand: ITimingCommand): Promise<void>;
    createMany(timingCommands: ITimingCommand[]): Promise<void>;
    deleteReceivedUntil(receivedUntil: Date): Promise<void>;
}
//# sourceMappingURL=timingCommandModel.d.ts.map