export interface ITermsAgreement {
    accountId: number;
    termsAndConditionsUid?: string;
    termsVersion: string;
    agreedOn: Date;
}
export interface ITermsModelRead {
    fetchByAccountId(accountId: number): Promise<ITermsAgreement | null>;
    hasAgreedWithTerms(accountId: number, termsVersion: string, termsAndConditionsUid?: string): Promise<boolean>;
    shouldAgreeWithTerms(accountId: number, termsVersion: string, termsAndConditionsUid?: string): Promise<boolean>;
}
export interface ITermsModelWrite {
    markTermsAgreed(termsAgreement: ITermsAgreement): Promise<void>;
}
export interface ITermsModelObservable {
    waitForAgreedTermsByAccountIdAndVersion(accountId: number, version: string): Promise<ITermsAgreement>;
}
//# sourceMappingURL=termsModel.d.ts.map