export interface IApiRequest {
    organizationUid: string;
    accountUid: string;
    companyUid: string;
    resource: string;
    method: string;
    createdAt: Date;
    createdAtHour: string;
    count: number;
}
export interface IApiRequestFilter {
    resource?: string;
    method?: string;
    createdFrom?: string;
    createdUntil?: string;
}
export interface IApiRequestAggregate {
    resource: IResource;
    accounts: string[];
    requestCount: number;
}
export interface IRequestCount {
    organizationUid: string;
    account: string;
    company: string;
    resource: string;
    method: string;
    dateTime: Date;
}
export interface IRequestDeleteKey {
    organizationUid: string;
    resource: string;
    method: string;
    hour: string;
}
export interface IResource {
    path: string;
    method: string;
}
export declare type IApiRequestsModel = IApiRequestsModelLatest & IApiRequestsModeStats;
export declare type IApiRequestCountModel = Pick<IApiRequestsModeStats, 'countRequest' | 'deleteRequest'> & Pick<IApiRequestsModelLatest, 'fetchListByOrigination' | 'fetchAllRequestFromLastHour'>;
export declare type IApiRequestStatsModel = Pick<IApiRequestsModeStats, 'create'> & Pick<IApiRequestsModelLatest, 'fetchListByOrigination' | 'fetchListByOrganizationWithFilter'>;
export interface IApiRequestsModelLatest {
    fetchListByOrigination(organizationUid: string): Promise<IApiRequest[]>;
    fetchAllRequestFromLastHour(dateTime: string): Promise<IApiRequest[]>;
    fetchListByOrganizationWithFilter(organizationUid: string, filter: IApiRequestFilter): Promise<IApiRequestAggregate[]>;
}
export interface IApiRequestsModeStats {
    create(requestObject: IApiRequest): Promise<void>;
    countRequest(request: IRequestCount): Promise<void>;
    deleteRequest(requestData: IRequestDeleteKey): Promise<void>;
}
//# sourceMappingURL=apiRequestModel.d.ts.map