/// <reference types="lib.es2017.observable" />
import IChanges from '../../IChanges';
import { IOrganization } from '../Organization/organizationModel';
import { IOriginator } from '../Originator/originator';
import { PolicyBase } from './policyModel';
import { IDevice } from '../Device/deviceModel';
/**
 * Contains all changes of specified policies grouped by their uid, each record must have timestamp and originator about
 * when and who made the change and optional Git-like comment
 * @param T is used to define IPolicyItem<T> interface i.e IPolicyItem<TimerSettingsV2>
 */
export interface IPolicyLog<T extends PolicyBase> {
    uid: string;
    name: string;
    note?: string;
    organizationUid: string;
    items: T[];
    archived: boolean;
    createdAt: Date;
    updatedAt: Date;
    originator: IOriginator;
}
export interface IStatusFilter {
    includeActive?: boolean;
    includeInactive?: boolean;
    includeArchived?: boolean;
}
export interface IPolicyReference {
    uid: string;
    name: string;
    organizationUid: string;
}
export declare type IPolicyLogModel<T extends PolicyBase> = IPolicyLogModelRead<T> & IPolicyLogModelWrite<T>;
declare type FieldSorterType<T extends PolicyBase> = Pick<IPolicyLog<T>, 'name' | 'createdAt' | 'updatedAt'> & {
    deviceCount: number;
    organizationTitle: string;
};
export interface IPolicyLogSorter<T extends PolicyBase> {
    field: keyof FieldSorterType<T>;
    direction: 'ascending' | 'descending';
}
export interface IPolicyLogModelRead<T extends PolicyBase> {
    fetchLatestByUid(uid: string): Promise<IPolicyLog<T> | null>;
    fetchLatestByUids(uids: IPolicyLog<T>['uid'][]): Promise<IPolicyLog<T>[]>;
    fetchLogByUid(uid: string, offset?: number, limit?: number): Promise<IPolicyLog<T>[]>;
    fetchReferenceListByDevice(device: IDevice): Promise<IPolicyReference[]>;
    fetchReferenceListByOrganizations(organizations: IOrganization[]): Promise<IPolicyReference[]>;
    fetchLatestListByOrganizations(organizations: IOrganization[], archived?: boolean, sorter?: IPolicyLogSorter<T>[], limit?: number, offset?: number, name?: string, createdUntil?: Date, statusFilter?: IStatusFilter): Promise<IPolicyLog<T>[]>;
    fetchLatestByOrganizationAndUid(organization: IOrganization, uid: string): Promise<IPolicyLog<T> | null>;
    countByUid(uid: string): Promise<number>;
    countLatestByOrganization(organizations: IOrganization[], archived?: boolean, name?: string, statusFilter?: IStatusFilter): Promise<number>;
}
export interface IPolicyLogModelWrite<T extends PolicyBase> {
    create(uid: string, name: string, organizationUid: string, createdAt: Date, originator: IOriginator): Promise<void>;
    clone(policyLogRow: IPolicyLog<T>, uid: string, name: string, organizationUid: string, createdAt: Date, originator: IOriginator): Promise<void>;
    updateItems(policyLogRow: IPolicyLog<T>, items: T[], updatedAt: Date, originator: IOriginator, note?: string): Promise<void>;
    updateName(policyLogRow: IPolicyLog<T>, name: string, updatedAt: Date, originator: IOriginator): Promise<void>;
    archive(policyLogRow: IPolicyLog<T>, updatedAt: Date, originator: IOriginator): Promise<void>;
    unarchive(policyLogRow: IPolicyLog<T>, updatedAt: Date, originator: IOriginator): Promise<void>;
    remove(policyLogRow: IPolicyLog<T>): Promise<void>;
}
export interface IPolicyLogModelObservable<T extends PolicyBase> {
    observeLatestListByUids(uids: string[]): Promise<Observable<IChanges<IPolicyLog<T>>, Error>>;
    observeLatestListByOrganizations(organization: IOrganization[], archived?: boolean, sorter?: IPolicyLogSorter<T> | IPolicyLogSorter<T>[], limt?: number, offset?: number, name?: string, statusFilter?: IStatusFilter): Promise<Observable<IPolicyLog<T>[], Error>>;
    observeLatestByUid(uid: string): Promise<Observable<IChanges<IPolicyLog<T>>, Error>>;
}
export {};
//# sourceMappingURL=policyLogModel.d.ts.map