import { IPackage } from './packageModel';
import ApplicationType from '@signageos/common-types/dist/Application/ApplicationType';
import { ISort } from '../../Lib/Sort/sort';
import { TPagination } from '../../Lib/Pagination/paginationTypes';
import { AndroidPackageSpecs, Abi as CommonAbi } from '@signageos/common-types/dist/Package/Android/specs';
/** composite identifier of packageName and version props */
export declare type PackageNameVersionTuple = [packageName: string, packageVersion: string];
/**
 * This is representing the one single package build (usually unique by checksum of single built package file)
 * E.g.:
 * Android - apk file sha256
 * TODO other platforms
 */
export declare type IPackageVersion = IAndroidPackageVersion | IBasePackageVersion;
export interface IBasePackageVersion {
    uid: string;
    createdAt: Date;
    createdByAccountId?: number;
    /**
     * Unique identification of package itself, used for relation to package entity
     */
    packageName: string;
    /**
     * Identification of application platform where the package is targeted to
     */
    applicationType: ApplicationType;
    /**
     * Human readable version of package (usually semver or something similar)
     */
    version: string;
    /**
     * Additional optional identification of build
     * Used on android platform for create unique url address to package file
     */
    build: string | null;
    /**
     * URL of the application icon extracted from APK archive
     */
    iconUrl: string | null;
    /**
     * Contains unique hash (usually checksum of package file) which is unique for every build
     * E.g.:
     * Android - apk file sha256
     * TODO other platforms
     */
    buildHash: string;
    releasedAt?: Date;
    specs?: object;
    deletedAt?: Date;
    publishedSince?: Date;
}
export interface IAndroidPackageVersion extends IBasePackageVersion {
    applicationType: 'android';
    specs: AndroidPackageSpecs;
}
/** @deprecated Use {@link AndroidPackageSpecs} instead */
export declare type IAndroidSpecs = AndroidPackageSpecs;
/** @deprecated Use {@link CommonAbi} instead */
export declare type Abi = CommonAbi;
export interface IPackageVersionPropertyFilter {
    packageName?: string;
    createdSince?: Date;
    createdUntil?: Date;
}
export interface IFetchPackageVersionListParams {
    filter?: IPackageVersionPropertyFilter;
    sort?: ISort<'createdAt'>;
    pagination?: TPagination;
}
export interface IPackageVersionModel {
    getPackageVersionIterator(): AsyncIterableIterator<IPackageVersion>;
    fetchByUid(uid: string): Promise<IPackageVersion | null>;
    fetchByPackageNameAndApplicationAndVersionAndBuild(packageName: string, applicationType: ApplicationType, version: string, build: string | null): Promise<IPackageVersion | null>;
    fetchListByPackageAndApplicationType(packageEntity: IPackage, applicationType: ApplicationType): Promise<IPackageVersion[]>;
    fetchListByPackageListAndApplicationType(packageEntity: IPackage[], applicationType: ApplicationType): Promise<IPackageVersion[]>;
    fetchListByPackageNames(packageNames: string[]): Promise<IPackageVersion[]>;
    fetchListByUids(uids: string[]): Promise<IPackageVersion[]>;
    fetchList(params?: IFetchPackageVersionListParams): Promise<IPackageVersion[]>;
    fetchListByPackageNameVersion(packageNameVersionTuples: PackageNameVersionTuple[]): Promise<IPackageVersion[]>;
    fetchListByApplication(applicationType: ApplicationType, onlyPublished?: boolean): Promise<IPackageVersion[]>;
    fetchByPackageNameAndApplicationTypeAndBuildHash(packageName: string, applicationType: ApplicationType, buildHash: string): Promise<IPackageVersion | null>;
    create(uid: string, packageRow: IPackage, applicationType: ApplicationType, buildHash: string, version: string, build: string | null, iconUrl: string | null, createdAt: Date, createdByAccountId: number | undefined, specs: AndroidPackageSpecs | undefined): Promise<void>;
    delete(packageVersion: IPackageVersion, deletedAt: Date): Promise<void>;
    fetchDeleted(): Promise<IPackageVersion[]>;
    /**
     * @param onlyReleased it is the not tagged semver `version`: 3.0.0, 5.2.1 (not 2.3.1-master.123 etc)
     */
    fetchLatestByApplication(applicationType: ApplicationType, packageName: string, onlyReleased?: boolean, onlyPublished?: boolean): Promise<IPackageVersion | null>;
    markAsPublished(packageVersionRow: IPackageVersion, publishedSince: Date): Promise<void>;
    markAsNotPublished(packageVersionRow: IPackageVersion): Promise<void>;
    update(uid: IPackageVersion['uid'], updateObject: Partial<Omit<IPackageVersion, 'uid' | 'createdAt'>>): Promise<void>;
}
//# sourceMappingURL=packageVersionModel.d.ts.map