import { TPagination } from '../../Lib/Pagination/paginationTypes';
import { ISort } from '../../Lib/Sort/sort';
export interface IPackage {
    uid: string;
    createdAt: Date;
    packageName: string;
    label: string;
    description: string | undefined;
    ownerOrganizationUid: string;
    createdByAccountId?: number;
    deletedAt?: Date;
}
export declare type IPackageIdentification = Pick<IPackage, 'uid'>;
/**
 * Special reserved packageName of package entity used to detect Cloud Control Core app.
 * Nobody can use it and has to be created in system automatically on startup system
 */
export declare const MANAGEMENT_PACKAGE_NAME = "signageos-management";
/**
 * Special reserved packageName of package entity used to detect Front Core app.
 * Nobody can use it and has to be created in system automatically on startup system
 */
export declare const FRONT_PACKAGE_NAME = "signageos-front";
export interface IPackagePropertyFilter {
    ownerOrganizationUids?: string[];
    packageName?: string;
    createdSince?: Date;
    createdUntil?: Date;
}
export interface IFetchPackageListParams {
    filter?: IPackagePropertyFilter;
    sort?: ISort<'createdAt' | 'label'>;
    pagination?: TPagination;
}
export interface IPackageModel {
    fetchByUid(uid: string): Promise<IPackage | null>;
    fetchByPackageName(packageName: string): Promise<IPackage | null>;
    fetchList(params?: IFetchPackageListParams): Promise<IPackage[]>;
    count(filter?: IPackagePropertyFilter): Promise<number>;
    fetchByOwnerOrganizationUid(ownerOrganizationUid: string): Promise<IPackage[]>;
    create(uid: string, packageName: string, createdAt: Date, label: string, description: string | undefined, ownerOrganizationUid: string, createdByAccountId?: number): Promise<void>;
    edit(uid: string, payload: {
        label?: string;
        description?: string;
    }): Promise<void>;
    delete(packageToDelete: IPackageIdentification, deletedAt: Date): Promise<void>;
    fetchDeleted(): Promise<IPackage[]>;
}
//# sourceMappingURL=packageModel.d.ts.map