"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateSubscriptionType = exports.createDefaultDistributionByDevicePlan = exports.createDefaultDistributionByBillingPlan = exports.OrderDirection = exports.SubscriptionType = void 0;
const subscription_1 = require("@signageos/common-types/dist/Subscription/subscription");
const Billing_1 = require("@signageos/common-types/dist/Billing/Billing");
/** @deprecated Use import from '@signageos/common-types/dist/Subscription/subscription' instead */
// eslint-disable-next-line no-redeclare
exports.SubscriptionType = subscription_1.SubscriptionType;
var OrderDirection;
(function (OrderDirection) {
    OrderDirection[OrderDirection["ASC"] = 1] = "ASC";
    OrderDirection[OrderDirection["DESC"] = -1] = "DESC";
})(OrderDirection = exports.OrderDirection || (exports.OrderDirection = {}));
function createDefaultDistributionByBillingPlan() {
    return {
        [Billing_1.BillingPlan.Open]: 0,
        [Billing_1.BillingPlan.Starter]: 0,
        [Billing_1.BillingPlan.Medium]: 0,
        [Billing_1.BillingPlan.Enterprise]: 0,
    };
}
exports.createDefaultDistributionByBillingPlan = createDefaultDistributionByBillingPlan;
function createDefaultDistributionByDevicePlan() {
    return {
        [exports.SubscriptionType.Open]: 0,
        [exports.SubscriptionType.Basic]: 0,
        [exports.SubscriptionType.Medium]: 0,
        [exports.SubscriptionType.All]: 0,
        [exports.SubscriptionType.Platform]: 0,
    };
}
exports.createDefaultDistributionByDevicePlan = createDefaultDistributionByDevicePlan;
function validateSubscriptionType(subscriptionType) {
    if (!Object.values(exports.SubscriptionType).includes(subscriptionType)) {
        throw new Error(`Invalid subscription type "${subscriptionType}" given.`);
    }
}
exports.validateSubscriptionType = validateSubscriptionType;
//# sourceMappingURL=organizationModel.js.map