/// <reference types="lib.es2017.observable" />
import IChanges from '../../IChanges';
export interface IOrganizationDetails {
    organizationUid: string;
    devicesCountAll?: number;
    devicesCountWeek?: number;
    devicesCountMonth?: number;
    devicesCountLastMonth?: number;
}
export interface IOrganizationDetailsModel extends IOrganizationDetailsModelWrite {
    fetchByOrganizationUid(organizationUid: string): Promise<IOrganizationDetails | null>;
    fetchListByOrganizationUids(organizationUids: string[]): Promise<IOrganizationDetails[]>;
}
export interface IOrganizationDetailsModelWrite {
    create(organizationUid: string): Promise<void>;
    updateDeviceStatistics(organizationUid: string, devicesCountAll: number, devicesCountWeek: number, devicesCountMonth: number, devicesCountLastMonth: number): Promise<void>;
}
export interface IOrganizationDetailsModelObservable {
    observeListByOrganizationUids(organizationUids: string[]): Promise<Observable<IChanges<IOrganizationDetails>, Error>>;
}
//# sourceMappingURL=organizationDetailsModel.d.ts.map