import { IIssuedServerLicenseValidity } from './issuedServerLicenseValidityModel';
import { IApplication } from '../Application/applicationModel';
import { IOrganizationIdentification, SubscriptionType } from '../Organization/organizationModel';
export interface IIssuedDeviceLicense {
    id: any;
    duid: string;
    applicationType: string;
    createdAt: Date;
    sourceIssuedServerLicenseValidityId: string | null;
    subscriptionType: SubscriptionType;
}
export interface IIssuedDeviceLicenseModel {
    create(duid: string, application: IApplication, createdAt: Date, sourceIssuedServerLicenseValidity: IIssuedServerLicenseValidity | undefined, subscriptionType: SubscriptionType): Promise<void>;
    fetchListByOrganizationCreatedBetween(organization: IOrganizationIdentification, createdSince: Date | undefined, createdUntil: Date | undefined): Promise<IIssuedDeviceLicense[]>;
}
//# sourceMappingURL=issuedDeviceLicenseModel.d.ts.map