/// <reference types="lib.es2017.observable" />
import IChanges from '../../../IChanges';
export interface ITestSuiteGroup {
    suiteType: string;
}
export interface ITestSuite extends ITestSuiteGroup {
    pendingTests: string[];
    passedTests: string[];
    failedTests: string[];
    startedAt: Date;
    passedAt?: Date;
    failedAt?: Date;
}
export interface IFrontDisplayVersion {
    id: any;
    version: string;
    createdAt?: Date;
    testSuites?: ITestSuite[];
}
export declare type IFrontDisplayVersionModel<TFrontDisplayVersion extends IFrontDisplayVersion> = IFrontDisplayVersionModelRead<TFrontDisplayVersion> & IFrontDisplayVersionModelWrite<TFrontDisplayVersion> & IFrontDisplayVersionModelObservable<TFrontDisplayVersion>;
export interface IFrontDisplayVersionModelRead<TFrontDisplayVersion extends IFrontDisplayVersion> {
    fetchById(id: any): Promise<TFrontDisplayVersion | null>;
    fetchByVersion(version: string): Promise<TFrontDisplayVersion | null>;
    fetchAll(): Promise<TFrontDisplayVersion[]>;
}
export interface IFrontDisplayVersionModelWrite<TFrontDisplayVersion extends IFrontDisplayVersion> {
    create(version: string, createdAt: Date): Promise<void>;
    setTestSuite(frontDisplayVersionRow: TFrontDisplayVersion, suiteGroup: ITestSuiteGroup, tests: {
        pendingTests: string[];
        passedTests: string[];
        failedTests: string[];
        startedAt: Date;
    }): Promise<void>;
    setTestSuitePassed(frontDisplayVersionRow: TFrontDisplayVersion, suiteGroup: ITestSuiteGroup, passedAt: Date): Promise<void>;
    setTestSuiteFailed(frontDisplayVersionRow: TFrontDisplayVersion, suiteGroup: ITestSuiteGroup, failedAt: Date): Promise<void>;
    addTestPassed(frontDisplayVersionRow: TFrontDisplayVersion, suiteGroup: ITestSuiteGroup, identification: string): Promise<void>;
    addTestFailed(frontDisplayVersionRow: TFrontDisplayVersion, suiteGroup: ITestSuiteGroup, identification: string): Promise<void>;
}
export interface IFrontDisplayVersionModelObservable<T extends IFrontDisplayVersion> {
    observeAll(): Promise<Observable<IChanges<T>, Error>>;
}
//# sourceMappingURL=frontDisplayVersionModel.d.ts.map