import { IApplication } from '../Application/applicationModel';
export interface IFirmwareVersion {
    uid: string;
    createdAt: Date;
    applicationType: string;
    version: string;
    type?: string;
    releasedAt?: Date;
}
export interface IFirmwareVersionModel {
    fetchByUid(uid: string): Promise<IFirmwareVersion | null>;
    fetchByApplicationAndVersion(application: IApplication, version: string, type: string | undefined): Promise<IFirmwareVersion | null>;
    fetchListByUids(uids: string[]): Promise<IFirmwareVersion[]>;
    fetchList(onlyReleased?: boolean): Promise<IFirmwareVersion[]>;
    create(application: IApplication, version: string, createdAt: Date, type: string | undefined): Promise<void>;
}
//# sourceMappingURL=firmwareVersionModel.d.ts.map