import { IDevice } from '../deviceModel';
export interface IDeviceTimerPropertyFilter {
    deviceIdentityHash?: string;
}
export interface IDeviceTimer {
    uid: string;
    deviceIdentityHash: string;
    type: string;
    volume: number;
    weekdays: string[];
    level: string;
    timeOn: string | null;
    timeOff: string | null;
    createdAt: Date;
    succeededAt: Date | null;
    failedAt: Date | null;
    postponedAt?: Date | null;
}
export interface IDeviceTimerModel {
    fetchByUid(uid: string): Promise<IDeviceTimer | null>;
    fetchByDevice(device: IDevice): Promise<IDeviceTimer | null>;
    fetchLatestSucceededByDeviceAndLevelAndType(device: IDevice, level: string, type: string): Promise<IDeviceTimer | null>;
    fetchFailedByDeviceList(deviceList: IDevice[], from?: Date): Promise<IDeviceTimer[]>;
    fetchLatestListByDevices(devices: IDevice[], level: string, type: string): Promise<IDeviceTimer[]>;
    fetchListByPropertyFilter(propertyFilter: IDeviceTimerPropertyFilter): Promise<IDeviceTimer[]>;
    countFailedByDevice(device: IDevice, from?: Date): Promise<number>;
    create(uid: string, device: IDevice, createdAt: Date, type: string, timeOn: string | null, timeOff: string | null, volume: number, weekdays: string[], level: string): Promise<void>;
    markSucceeded(deviceTimerRow: IDeviceTimer, succeededAt: Date): Promise<void>;
    markFailed(deviceTimerRow: IDeviceTimer, failedAt: Date): Promise<void>;
    markPostponed(deviceTimerRow: IDeviceTimer, postponedAt: Date): Promise<void>;
}
//# sourceMappingURL=deviceTimerModel.d.ts.map