import { IDevice } from '../deviceModel';
export interface IDeviceTest {
    uid: string;
    deviceIdentityHash: string;
    pendingTests: string[];
    successfulTests: string[];
    skippedTests: string[];
    failedTests: string[];
    testResults: {
        [testIdentifier: string]: TestResult;
    };
    createdAt: Date;
    finishedAt?: Date | null;
    canceledAt?: Date | null;
    failedAt?: Date | null;
}
export interface ItemResult {
    title: string;
    skipped: boolean;
    failed: boolean;
    duration: number;
    reason?: string;
}
export interface TestCaseResult {
    beforeEach: ItemResult[];
    test: ItemResult;
    afterEach: ItemResult[];
}
export interface TestResult {
    title: string;
    total: number;
    successful: number;
    skipped: number;
    failed: number;
    duration: number;
    describe: TestResult[];
    test: TestCaseResult[];
    before: ItemResult[];
    after: ItemResult[];
}
export interface IDeviceTestModel {
    fetchByUid(uid: string): Promise<IDeviceTest | null>;
    fetchByDevice(device: IDevice): Promise<IDeviceTest | null>;
    fetchLatestByDevice(device: IDevice): Promise<IDeviceTest | null>;
    create(uid: string, device: IDevice, tests: string[], createdAt: Date): Promise<void>;
    markFinished(deviceTestRow: IDeviceTest, finishedAt: Date): Promise<void>;
    markCanceled(deviceTestRow: IDeviceTest, canceledAt: Date): Promise<void>;
    markFailed(deviceTestRow: IDeviceTest, failedAt: Date): Promise<void>;
    setTestSucceeded(deviceTestRow: IDeviceTest, test: string, testResult?: TestResult): Promise<void>;
    setTestSkipped(deviceTestRow: IDeviceTest, test: string, testResult?: TestResult): Promise<void>;
    setTestFailed(deviceTestRow: IDeviceTest, test: string, testResult?: TestResult): Promise<void>;
}
//# sourceMappingURL=deviceTestModel.d.ts.map