import { IDevice } from '../../deviceModel';
export interface IDeviceAppletTest {
    uid: string;
    appletUid: string;
    appletVersion: string;
    deviceIdentityHash: string;
    pendingTests: string[];
    successfulTests: string[];
    failedTests: string[];
    createdAt: Date;
    finishedAt?: Date | null;
    canceledAt?: Date | null;
    failedAt?: Date | null;
}
export interface IDeviceAppletTestModel {
    fetchByUid(uid: string): Promise<IDeviceAppletTest | null>;
    fetchLatestByDevice(device: IDevice): Promise<IDeviceAppletTest | null>;
    fetchLatestByDeviceAndAppletUidAndAppletVersion(device: IDevice, appletUid: string, appletVersion: string): Promise<IDeviceAppletTest | null>;
    create(uid: string, appletUid: string, appletVersion: string, device: IDevice, tests: string[], createdAt: Date): Promise<void>;
    markFinished(deviceAppletTestRow: IDeviceAppletTest, finishedAt: Date): Promise<void>;
    markCanceled(deviceAppletTestRow: IDeviceAppletTest, canceledAt: Date): Promise<void>;
    markFailed(deviceAppletTestRow: IDeviceAppletTest, failedAt: Date): Promise<void>;
    setTestSucceeded(deviceAppletTestRow: IDeviceAppletTest, test: string): Promise<void>;
    setTestFailed(deviceAppletTestRow: IDeviceAppletTest, test: string): Promise<void>;
}
//# sourceMappingURL=deviceAppletTestModel.d.ts.map