export interface IDeviceAliveness {
    aliveAt: Date;
}
export declare type DeviceAlivenessMap = Map<string, IDeviceAliveness>;
export interface IDeviceAlivenessModel {
    fetchMapByDuids(duids: string[]): Promise<DeviceAlivenessMap>;
    fetchByDuid(duid: string): Promise<IDeviceAliveness | null>;
    markAlive(duid: string, aliveAt: Date): Promise<void>;
    fetchAllIterator(): AsyncIterableIterator<[duid: string, aliveness: IDeviceAliveness]>;
}
//# sourceMappingURL=deviceAlivenessModel.d.ts.map