import { IDevice } from '../deviceModel';
export interface IDeviceResizePropertyFilter {
    deviceIdentityHash?: string;
}
export interface IDeviceResize {
    uid: string;
    deviceIdentityHash: string;
    resolution: string;
    orientation: string;
    videoOrientation: string | null;
    createdAt: Date;
    succeededAt: Date | null;
    failedAt: Date | null;
}
export interface IDeviceResizeModel {
    fetchByUid(uid: string): Promise<IDeviceResize | null>;
    fetchByDevice(device: IDevice): Promise<IDeviceResize | null>;
    fetchLatestSucceededByDevice(device: IDevice): Promise<IDeviceResize | null>;
    fetchFailedByDeviceList(deviceList: IDevice[], from?: Date): Promise<IDeviceResize[]>;
    fetchLatestListByDevices(devices: IDevice[]): Promise<IDeviceResize[]>;
    fetchListByPropertyFilter(propertyFilter: IDeviceResizePropertyFilter): Promise<IDeviceResize[]>;
    countFailedByDevice(device: IDevice, from?: Date): Promise<number>;
    create(uid: string, device: IDevice, resolution: string, orientation: string, createdAt: Date, videoOrientation?: string): Promise<void>;
    markSucceeded(deviceResizeRow: IDeviceResize, succeededAt: Date): Promise<void>;
    markFailed(deviceResizeRow: IDeviceResize, failedAt: Date): Promise<void>;
}
//# sourceMappingURL=deviceResizeModel.d.ts.map