/// <reference types="lib.es2017.observable" />
import { IModelCreatable } from '../../../Lib/Model/IModelCreatable';
import { IModelDeletable } from '../../../Lib/Model/IModelDeletable';
import { IModelReadable } from '../../../Lib/Model/IModelReadable';
import { IModelUpdatable } from '../../../Lib/Model/IModelUpdatable';
import { ICreatable, IEntity, IUpdatable } from '../../../Lib/Model/model';
import { DeviceProvisioningRecipeStatus } from '@signageos/common-types/dist/Device/ProvisioningRecipe/deviceProvisioningRecipe';
import { IOrganization } from '../../Organization/organizationModel';
import { IDevice } from '../deviceModel';
import { IOrganizationTag } from '../../Organization/Tag/organizationTagModel';
import { IPolicy } from '../../Policy/policyModel';
import { ILocation } from '../../Location/locationModel';
import { PaginationAndSorting } from '../../../Lib/Pagination/paginationTypes';
import IChanges from '../../../IChanges';
export interface IDeviceProvisioningRecipeBase extends IEntity {
    organizationUid: IOrganization['uid'];
    deviceUid?: IDevice['uid'];
    deviceName?: string;
    serialNumber?: string;
    macAddress?: string;
    model?: string;
    brand: string;
    tagUids?: IOrganizationTag['uid'][];
    policyUid?: IPolicy['uid'];
    locationUid?: ILocation['uid'];
    confirmedOwnership?: boolean;
    status: DeviceProvisioningRecipeStatus;
}
export interface DeviceProvisioningRecipeFilter {
    search?: string;
    organizationUids?: IOrganization['uid'][];
    status?: DeviceProvisioningRecipeStatus;
    brand?: string;
    tagUids?: IOrganizationTag['uid'][];
    policyUids?: IPolicy['uid'][];
    locationUids?: ILocation['uid'][];
    serialNumber?: string;
    model?: string;
    macAddress?: string | string[];
}
/** @deprecated use DeviceProvisioningRecipeFilter instead */
export declare type DeviceProvisionigRecipeFilter = DeviceProvisioningRecipeFilter;
export declare type DeviceProvisioningRecipeSorting = 'serialNumber' | 'deviceName' | 'model' | 'status' | 'createdAt';
export declare type IDeviceProvisioningRecipe = IDeviceProvisioningRecipeBase & ICreatable & IUpdatable;
export declare type DeviceProvisioningRecipeEmptyFieldCountable = 'deviceName' | 'policyUid' | 'locationUid';
export interface IDeviceProvisioningRecipeModelRead extends IModelReadable<IDeviceProvisioningRecipe> {
    fetchByDeviceUid(deviceUid: IDevice['uid']): Promise<IDeviceProvisioningRecipe | null>;
    fetchListByFilters(
    /** Multiple filters are resolved as OR logic */
    filters?: DeviceProvisioningRecipeFilter[], paginationAndSorting?: PaginationAndSorting<DeviceProvisioningRecipeSorting>): Promise<IDeviceProvisioningRecipe[]>;
    countByFilters(
    /** Multiple filters are resolved as OR logic */
    filters?: DeviceProvisioningRecipeFilter[]): Promise<number>;
    /**
     * According to the passed array of keys (and optionally property filter), counts the number of items within the collection
     * with an empty, undefined, or null value for respective keys.
     * E.g. if you pass array `['policyUid', 'locationUid']`, the method returns an record `{ policyUid: number; locationUid: number; }`.
     */
    countEmptyFiledsByFilters(fields: DeviceProvisioningRecipeEmptyFieldCountable[], 
    /** Multiple filters are resolved as OR logic */
    filters?: DeviceProvisioningRecipeFilter[]): Promise<Record<DeviceProvisioningRecipeEmptyFieldCountable, number>>;
}
export interface IDeviceProvisioningRecipeModelWrite extends IModelCreatable<IDeviceProvisioningRecipe>, IModelUpdatable<IDeviceProvisioningRecipe>, IModelDeletable<IDeviceProvisioningRecipe> {
}
export declare type IDeviceProvisioningRecipeModel = IDeviceProvisioningRecipeModelRead & IDeviceProvisioningRecipeModelWrite;
export interface IDeviceProvisioningRecipeModelObservable {
    observeByUid(uid: string): Promise<Observable<IChanges<IDeviceProvisioningRecipe>, Error>>;
    observeListByFilters(filters?: DeviceProvisioningRecipeFilter[], paginationAndSorting?: PaginationAndSorting<DeviceProvisioningRecipeSorting>): Promise<Observable<IDeviceProvisioningRecipe[], Error>>;
}
//# sourceMappingURL=deviceProvisioningRecipeModel.d.ts.map