/// <reference types="lib.es2017.observable" />
import { IDevice } from '../deviceModel';
import { IPolicy } from '../../Policy/policyModel';
import IChanges from '../../../IChanges';
export interface IDevicePolicyStatusDeviceSelector {
    deviceIdentityHash: string;
    policyUid: string;
}
export interface IDevicePolicyStatusItemSelector<T extends string> {
    policyUid: string;
    itemType: T;
}
export interface IDevicePolicyStatus<T extends string> {
    deviceIdentityHash: string;
    policyUid: string;
    itemType: T;
    success: boolean;
    updatedAt: Date;
}
export declare type IDevicePolicyStatusModel<T extends string> = IDevicePolicyStatusModelRead<T> & IDevicePolicyStatusModelWrite<T> & IDevicePolicyStatusModelObservable<T>;
export interface IDevicePolicyStatusModelRead<T extends string> {
    fetchByDeviceAndPolicyAndItemType(device: IDevice, policy: IPolicy, itemType: T): Promise<IDevicePolicyStatus<T> | null>;
    fetchListByDeviceAndPolicy(device: IDevice, policy: IPolicy): Promise<IDevicePolicyStatus<T>[]>;
    fetchListByDeviceAndItemType(device: IDevice, itemType: T): Promise<IDevicePolicyStatus<T>[]>;
    fetchListByDevice(device: IDevice): Promise<IDevicePolicyStatus<T>[]>;
}
export interface IDevicePolicyStatusModelWrite<T extends string> {
    upsert(device: IDevice, policy: IPolicy, itemType: T, success: boolean, updatedAt: Date): Promise<void>;
    remove(devicePolicyStatusRow: IDevicePolicyStatus<T>): Promise<void>;
    removeByDeviceAndPolicy(device: IDevice, policy: IPolicy): Promise<void>;
    removeByPolicyAndItemType(policy: IPolicy, itemType: T): Promise<void>;
}
export interface IDevicePolicyStatusModelObservable<T extends string> {
    observeByDevice(device: IDevice): Promise<Observable<IChanges<IDevicePolicyStatus<T> | IDevicePolicyStatusDeviceSelector>, Error>>;
    observeByPolicy(policy: IPolicy): Promise<Observable<IChanges<IDevicePolicyStatus<T> | IDevicePolicyStatusItemSelector<T>>, Error>>;
}
//# sourceMappingURL=devicePolicyStatusModel.d.ts.map