import { IDevice } from '../deviceModel';
export interface IDevicePackageStartPropertyFilter {
    deviceIdentityHash?: string;
}
export interface IDevicePackageStart {
    uid: string;
    deviceIdentityHash: string;
    createdAt: Date;
    packageName: string;
    succeededAt: Date | null;
    failedAt: Date | null;
}
export interface IDevicePackageStartModel {
    fetchByUid(uid: string): Promise<IDevicePackageStart | null>;
    fetchByDevice(device: IDevice): Promise<IDevicePackageStart | null>;
    fetchLatestListByDevices(devices: IDevice[]): Promise<IDevicePackageStart[]>;
    fetchListByPropertyFilter(propertyFilter: IDevicePackageStartPropertyFilter): Promise<IDevicePackageStart[]>;
    create(uid: string, device: IDevice, packageName: string, createdAt: Date): Promise<void>;
    markSucceeded(devicePackageInstallRow: IDevicePackageStart, succeededAt: Date): Promise<void>;
    markFailed(devicePackageInstallRow: IDevicePackageStart, failedAt: Date): Promise<void>;
}
//# sourceMappingURL=devicePackageStartModel.d.ts.map