import { IDevice } from '../deviceModel';
import { IPackageVersion } from '../../Package/packageVersionModel';
export interface IDevicePackageInstallPropertyFilter {
    deviceIdentityHash?: string;
}
export interface IDevicePackageInstall {
    uid: string;
    deviceIdentityHash: string;
    createdAt: Date;
    packageVersionUid: string;
    succeededAt: Date | null;
    failedAt: Date | null;
    postponedAt: Date | null;
}
export interface IDevicePackageInstallModel {
    fetchByUid(uid: string): Promise<IDevicePackageInstall | null>;
    fetchByDevice(device: IDevice): Promise<IDevicePackageInstall | null>;
    fetchLatestListByDevices(devices: IDevice[]): Promise<IDevicePackageInstall[]>;
    fetchListByPropertyFilter(propertyFilter: IDevicePackageInstallPropertyFilter): Promise<IDevicePackageInstall[]>;
    create(uid: string, device: IDevice, packageVersion: IPackageVersion, createdAt: Date): Promise<void>;
    markSucceeded(devicePackageInstallRow: IDevicePackageInstall, succeededAt: Date): Promise<void>;
    markFailed(devicePackageInstallRow: IDevicePackageInstall, failedAt: Date): Promise<void>;
    markPostponed(devicePackageInstallRow: IDevicePackageInstall, postponedAt: Date): Promise<void>;
}
//# sourceMappingURL=devicePackageInstallModel.d.ts.map