"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidMonitoringLogPropertyValueError = void 0;
const dataType_1 = require("./dataType");
class InvalidMonitoringLogPropertyValueError extends Error {
    constructor(propertyName, type, value) {
        super(`Monitoring log object property "${propertyName}" expected to be ${formatDataTypeSuperset(type)}, ${JSON.stringify(value)} given.`);
        this.propertyName = propertyName;
        this.type = type;
        this.value = value;
        Object.setPrototypeOf(this, InvalidMonitoringLogPropertyValueError.prototype);
    }
}
exports.InvalidMonitoringLogPropertyValueError = InvalidMonitoringLogPropertyValueError;
function formatDataTypeSuperset(type) {
    return Object.values(dataType_1.DataType)
        .filter((dataType) => (0, dataType_1.isOfDataType)(type, dataType))
        .map((dataType) => `'${dataType_1.DataType[dataType]}'`)
        .join(', ');
}
//# sourceMappingURL=errors.js.map