"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isOfDataType = exports.DataType = void 0;
/**
 * Binary representation of data type.
 * It respect binary operations for comparison to allow combine more types together.
 * For example `DataType.BOOLEAN | DataType.NULL` is a valid type.
 */
var DataType;
(function (DataType) {
    DataType[DataType["NULL"] = 1] = "NULL";
    DataType[DataType["TIMESTAMP"] = 2] = "TIMESTAMP";
    DataType[DataType["INT"] = 4] = "INT";
    DataType[DataType["STRING"] = 8] = "STRING";
    DataType[DataType["JSON"] = 16] = "JSON";
    DataType[DataType["BOOLEAN"] = 32] = "BOOLEAN";
    DataType[DataType["FLOAT"] = 64] = "FLOAT";
    DataType[DataType["MISSING"] = 128] = "MISSING";
})(DataType = exports.DataType || (exports.DataType = {}));
/**
 * It returns true when the given value data type is at least a superset of compareTo data type.
 * Example:
 * isOfDataType(DataType.INT | DataType.FLOAT, DataType.INT) // true
 * isOfDataType(DataType.STRING | DataType.FLOAT, DataType.INT) // false
 */
function isOfDataType(value, compareTo) {
    // This bitwise operator is intended
    // eslint-disable-next-line no-bitwise
    return (value & compareTo) !== 0;
}
exports.isOfDataType = isOfDataType;
//# sourceMappingURL=dataType.js.map