/// <reference types="lib.es2017.observable" />
import { IDevice, IDeviceArtificialIdentification } from '../deviceModel';
import IChanges from '../../../IChanges';
import IPartialChanges from '../../../IPartialChanges';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
export declare type DeviceInfoFieldSorterType = 'storage' | 'timezone' | 'managementPackageVersion' | 'frontPackageVersion';
export interface IDeviceInfoPropertySorter {
    field: DeviceInfoFieldSorterType;
    direction: 'ascending' | 'descending';
}
export interface IProxy {
    enabled?: boolean;
    uri?: string;
}
export interface INetworkInterface {
    macAddress: string;
    ipAddress?: string | null;
    netmask?: string | null;
    gateway?: string | null;
    domainNameServers?: string[] | null;
    interfaceName?: string | null;
    ssid?: string;
    signalStrength?: number;
}
export interface IBatteryStatus {
    percentage: number;
    chargeType: string;
    isCharging: boolean;
    lastChargingTime: Date | null;
    updatedAt: Date;
}
export interface IStorageStatus {
    internal: {
        capacity: number;
        freeSpace: number;
    };
    removable: {
        capacity: number;
        freeSpace: number;
    };
    updatedAt: Date;
}
export interface ICurrentTime {
    timestamp: number;
    timezoneOffset: number;
    timezone: string | null;
    updatedAt: Date;
    ntpServer?: string;
}
export declare type ResolutionItem = {
    width: number;
    height: number;
    framerate?: number;
};
export declare type ResolutionList = ResolutionItem[];
export declare type ISpecs = IAndroidSpecs;
/**
 * Android specific device info specs
 * Example values in comments
 */
export interface IAndroidSpecs {
    build: {
        version: {
            release: string;
            sdk: number;
            codename: string;
        };
        product: {
            brand: string;
            model: string;
            supportedAbis: string[];
            manufacturer?: string;
            device?: string;
            board?: string;
        };
    };
    signatures: {
        framework: {
            sha256: string;
        };
    };
}
export interface IMonitoringLogHeader {
    type: DeviceTelemetryType;
    size: number;
    oldestLogId: string;
    latestLogId: string;
}
export interface IDeviceInfo {
    identityHash: string;
    networkInterfaces?: {
        wifi?: INetworkInterface;
        ethernet?: INetworkInterface;
    } | null;
    batteryStatus?: IBatteryStatus | null;
    storageStatus?: IStorageStatus | null;
    currentTime?: ICurrentTime | null;
    incorrectTime?: boolean;
    supportedResolutions?: ResolutionList | null;
    specs?: ISpecs;
    policyItemTypes?: string[];
    proxy?: IProxy;
    /**
     * Contains version name of CC management package specific for current applicationType
     */
    managementPackageVersion?: string | null;
    /**
     * Numeric representation of managementPackageVersion which can be used for searching
     */
    managementPackageVersionNumber?: number | null;
    /**
     * Contains version name of front package specific for current applicationType
     */
    frontPackageVersion?: string | null;
    /**
     * Numeric representation of frontPackageVersion which can be used for searching
     */
    frontPackageVersionNumber?: number | null;
}
export declare type IDeviceInfoModel = IDeviceInfoModelRead & IDeviceInfoModelWrite & IDeviceInfoModelObservable;
export interface IDeviceInfoPropertyFilter {
    identityHashes?: string[];
    ethernetMacAddress?: string | RegExp;
    ethernetIpAddress?: string | RegExp;
    wifiMacAddress?: string | RegExp;
    wifiIpAddress?: string | RegExp;
    managementPackageVersion?: string | null;
    frontPackageVersion?: string | null;
}
export interface IUpdateNetworkInterface {
    networkInterface: 'wifi' | 'ethernet';
    macAddress: string;
    ipAddress?: string;
    netmask?: string;
    gateway?: string;
    domainNameServers?: string[];
    interfaceName?: string;
    ssid?: string;
    signalStrength?: number;
}
export interface IDeviceInfoModelRead {
    fetchByIdentityHash(identityHash: string): Promise<IDeviceInfo | null>;
    fetchListByDevices(devices: IDevice[]): Promise<IDeviceInfo[]>;
    fetchListByIdentityHashes(identityHashes: string[], sorter?: IDeviceInfoPropertySorter, offset?: number, limit?: number): Promise<IDeviceInfo[]>;
    fetchListByPropertyFilter(propertyFilter: IDeviceInfoPropertyFilter): Promise<IDeviceInfo[]>;
    fetchIdentityHashesByPropertyFilter(propertyFilter: IDeviceInfoPropertyFilter): Promise<string[]>;
    fetchIdentityHashesByStorageStatus(key: 'minStorageStatusPercentage' | 'maxStorageStatusPercentage', value: number): Promise<string[]>;
}
export interface IDeviceInfoModelWrite {
    create(identityHash: string): Promise<void>;
    updateNetworkInterface(deviceInfoRow: IDeviceInfo, networkInterface: IUpdateNetworkInterface): Promise<void>;
    updateSpecs(deviceInfoRow: IDeviceInfo, specs: ISpecs): Promise<void>;
    updateCurrentTime(deviceInfoRow: IDeviceInfo, currentTime: ICurrentTime, isIncorrect?: boolean): Promise<void>;
    updateSupportedResolutions(deviceInfoRow: IDeviceInfo, supportedResolutions: ResolutionList): Promise<void>;
    updateBatteryStatus(deviceInfoRow: IDeviceInfo, batteryStatus: IBatteryStatus): Promise<void>;
    updateStorageStatus(deviceInfoRow: IDeviceInfo, storageStatus: IStorageStatus): Promise<void>;
    updatePolicyItemTypes(deviceInfoRow: IDeviceInfo, policyItemTypes: string[]): Promise<void>;
    updateProxy(deviceInfoRow: IDeviceInfo, proxy: IProxy): Promise<void>;
    updateManagementPackageVersion(deviceIdentification: IDeviceArtificialIdentification, managementPackageVersion: string | null): Promise<void>;
    updateFrontPackageVersion(deviceIdentification: IDeviceArtificialIdentification, frontPackageVersion: string | null): Promise<void>;
}
export interface IDeviceInfoModelObservable {
    observeListByIdentityHashes(identityHashes: string[]): Promise<Observable<IChanges<IDeviceInfo> | IPartialChanges<IDeviceInfo, 'identityHash'>, Error>>;
}
//# sourceMappingURL=deviceInfoModel.d.ts.map