import { IDevice } from '../deviceModel';
import { IFirmwareVersion } from '../../Firmware/firmwareVersionModel';
export interface IDeviceFirmwareVersion {
    uid: string;
    createdAt: Date;
    deviceIdentityHash: string;
    version: string;
}
export interface IDeviceFirmwareVersionModel {
    fetchByUid(uid: string): Promise<IDeviceFirmwareVersion | null>;
    fetchByDevice(device: IDevice): Promise<IDeviceFirmwareVersion | null>;
    fetchListByDevices(devices: IDevice[]): Promise<IDeviceFirmwareVersion[]>;
    create(uid: string, createdAt: Date, device: IDevice, firmwareVersion: IFirmwareVersion): Promise<void>;
    remove(deviceFirmwareVersionRow: IDeviceFirmwareVersion): Promise<void>;
}
//# sourceMappingURL=deviceFirmwareVersionModel.d.ts.map