import { IDevice } from '../deviceModel';
export interface IDeviceDateTimePropertyFilter {
    deviceIdentityHash?: string;
}
export interface IDeviceDateTime {
    uid: string;
    deviceIdentityHash: string;
    timestamp: number;
    timezone: string;
    createdAt: Date;
    succeededAt?: Date;
    failedAt?: Date;
    postponedAt?: Date;
}
export interface IDeviceDateTimeModel {
    fetchByUid(uid: string): Promise<IDeviceDateTime | null>;
    fetchByDevice(device: IDevice): Promise<IDeviceDateTime | null>;
    fetchLatestSucceededByDevice(device: IDevice): Promise<IDeviceDateTime | null>;
    fetchListByDeviceAndStatus(device: IDevice, status?: string, limit?: number): Promise<IDeviceDateTime[]>;
    fetchLatestListByDevices(devices: IDevice[]): Promise<IDeviceDateTime[]>;
    fetchListByPropertyFilter(propertyFilter: IDeviceDateTimePropertyFilter): Promise<IDeviceDateTime[]>;
    create(uid: string, device: IDevice, timestamp: number, timezone: string, createdAt: Date, ntpServer?: string): Promise<void>;
    markSucceeded(deviceDateTimeRow: IDeviceDateTime, succeededAt: Date): Promise<void>;
    markFailed(deviceDateTimeRow: IDeviceDateTime, failedAt: Date): Promise<void>;
    markPostponed(deviceDateTimeRow: IDeviceDateTime, postponedAt: Date): Promise<void>;
}
//# sourceMappingURL=deviceDateTimeModel.d.ts.map