import { IDevice } from '../deviceModel';
import { SubscriptionType } from '../../Organization/organizationModel';
import { SocketDriver } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
import { ITelemetryConfigurationCheckIntervals } from '@signageos/common-types/dist/Device/MonitoringLog/TelemetryIntervals';
import { ActionsLimit } from '@signageos/common-types/dist/Device/Actions/ActionLimit';
/**
 * When some values are omitted (undefined) keep original value.
 * null value set the value to nothing (device default)
 */
export interface IConfigValues {
    platformUri?: string | null;
    staticBaseUrl?: string | null;
    uploadBaseUrl?: string | null;
    weinreUri?: string | null;
    extendedManagementUrl?: string | null;
    socketDriver?: SocketDriver | null;
}
export interface IDeviceConfiguration extends Required<IConfigValues> {
    deviceIdentityHash: string;
    createdAt: Date;
    bannedSince: Date | null;
    /** null means that device uses it's application default subscriptionType built in */
    subscriptionType: SubscriptionType | null;
    /** This is not configuration but just info about last request from device */
    lastUsedProtocol?: string | null;
    updatedAt: Date;
    extendedTelemetryEnabledUntil?: Date | null;
    telemetryIntervals?: Partial<ITelemetryConfigurationCheckIntervals> | null;
    offlineActionsLimits?: ActionsLimit | null;
}
export interface IDeviceConfigurationModel<T extends IDeviceConfiguration = IDeviceConfiguration> {
    fetchListByIdentityHashes(identityHashes: string[]): Promise<T[]>;
    fetchByDevice(deviceRow: IDevice): Promise<T | null>;
    setUpdatedAt(deviceConfigurationRow: T, updatedAt: Date): Promise<void>;
    create(deviceRow: IDevice, createdAt: Date, values: Required<IConfigValues>, subscriptionType: SubscriptionType | null): Promise<void>;
    update(deviceConfigurationRow: T, values: IConfigValues, updatedAt: Date): Promise<void>;
    setLastUsedProtocol(deviceConfigurationRow: T, lastUsedProtocol: string | null): Promise<void>;
    markBanned(deviceConfigurationRow: T, bannedSince: Date): Promise<void>;
    markApproved(deviceConfigurationRow: T, approvedSince: Date): Promise<void>;
    changeSubscriptionType(deviceConfigurationRow: T, subscriptionType: SubscriptionType | null, updatedAt: Date): Promise<void>;
    enableExtendedTelemetry(deviceConfigurationRow: T, enabledUntil: Date, updatedAt: Date): Promise<void>;
    disableExtendedTelemetry(deviceConfigurationRow: T, updatedAt: Date): Promise<void>;
    setTelemetryIntervals(deviceConfigurationRow: T, updatedAt: Date, telemetryIntervals: Partial<ITelemetryConfigurationCheckIntervals> | null): Promise<void>;
    setOfflineActionsLimits(deviceConfigurationRow: T, updatedAt: Date, offlineActionsLimits: ActionsLimit | null): Promise<void>;
}
//# sourceMappingURL=deviceConfigurationModel.d.ts.map