/// <reference types="lib.es2017.observable" />
import { IOriginator } from '../Originator/originator';
import { PaginationAndSorting } from '../../Lib/Pagination/paginationTypes';
import { LogData } from '@signageos/common-types/dist/BulkOperation/Types';
import { BulkOperationStatus, DeviceActionType } from '@signageos/common-types/dist/BulkOperation/Enums';
import IChanges from '../../IChanges';
export interface IDeviceUids {
    uid: string;
    identityHash: string;
}
export interface IRollingUpdate {
    batchSize: number;
    /** time in ms */
    batchDelay?: number;
    /** How many devices is allowed to fail bulk operation, value in % */
    stopThreshold?: number;
}
export interface IFilter {
    identityHash?: string;
    identityHashes?: string[];
    identityHashesExclude?: string[];
    uids?: string[];
    uidsExclude?: string[];
    accountId?: number;
    organizationUid?: string;
    applicationType?: string;
    applicationTypeNotEqual?: string;
    model?: string;
    firmwareVersion?: string;
    search?: string;
    minStorageStatusPercentage?: number;
    maxStorageStatusPercentage?: number;
    bannedSince?: Date;
    tagUids?: string[];
    policyUids?: string[];
    createdSince?: Date;
    createdUntil?: Date;
    /**
     * If filter is enabled using threshold value in milliseconds,
     * it filter in only devices with deviceInfo.currentTime.timestamp
     * in range of threshold before and after comparing to deviceInfo.currentTime.updatedAt.
     * Additionally, it filter in devices with mismatched timezone compared to the last updated timezone from deviceActionLog.
     * This filter drastically decrease performance of fetch due to absence of indexes and joining collections.
     */
    onlyWithTimeOutOfThresholdMs?: number;
    filterModelName?: string;
}
export interface IBulkOperation<T, A extends string> {
    uid: string;
    name?: string;
    filter: IFilter;
    deviceUids: IDeviceUids[];
    failedDeviceUids: string[];
    successfulDeviceUids: string[];
    skippedDeviceUids: string[];
    inProgressDeviceUids: string[];
    createdAt: Date;
    pausedAt?: Date;
    stoppedAt?: Date;
    resumedAt?: Date;
    archivedAt?: Date;
    finishedAt?: Date;
    isRunning?: boolean;
    currentStatus: BulkOperationStatus;
    schedule?: {
        datetime: Date;
        timezone?: string;
        /** Resolve filter at the time of execution instead of creation time */
        deferFilter?: boolean;
    };
    rollingUpdate?: IRollingUpdate;
    operationType: A;
    data: T;
    progress: {
        total: number;
        failed: number;
        inProgress: number;
        succeeded: number;
        skipped: number;
    };
    originator: IOriginator;
    /** Organization uids afftected devices belong to */
    organizationUids: string[];
    isDraft?: boolean;
}
export declare type BulkOperationSortField = 'currentStatus' | 'name' | 'devices' | 'createdAt' | 'scheduledAt';
export declare type IBulkOperationAlias = IBulkOperation<LogData[DeviceActionType], DeviceActionType>;
export declare type BulkResumedAt = {
    resumedAt: Date;
};
export declare type BulkStoppedAt = {
    stoppedAt: Date;
};
export declare type BulkPausedAt = {
    pausedAt: Date;
};
export declare type BulkArchivedAt = {
    archivedAt: Date;
};
export declare type BulkFinishedAt = {
    finishedAt: Date;
};
export declare type UpdateDateRecord = {
    rollingUpdate?: IRollingUpdate;
    currentStatus?: BulkOperationStatus;
} & (BulkResumedAt | BulkStoppedAt | BulkPausedAt | BulkArchivedAt | BulkFinishedAt);
export interface IBulkOperationFilter {
    name?: string;
    currentStatus?: BulkOperationStatus[];
}
export interface IBulkOperationModelRead<A extends IBulkOperationAlias> {
    fetchByUid(bulkOperationId: string): Promise<A | null>;
    /** @param fetchDrafts If is set to true returns only bulk operation drafts otherwise returns only finished bulk operations */
    fetchByOrganizationUids(organizationUids: string[], paginationAndSorting?: PaginationAndSorting<BulkOperationSortField>, fetchDrafts?: boolean, filter?: IBulkOperationFilter): Promise<A[]>;
    fetchCountByOrganizationUids(organizationUids: string[], fetchDrafts?: boolean, filter?: IBulkOperationFilter): Promise<number>;
    fetchActiveBulkOperations(date: Date): Promise<A[]>;
}
export interface IBulkOperationModelWrite<A extends IBulkOperationAlias> {
    create(record: A): Promise<void>;
    updateFailedDevice(bulkOperationId: string, deviceUid: string, decrementInProgress?: boolean): Promise<void>;
    updateSuccessfulDevice(bulkOperationId: string, deviceUid: string, decrementInProgress?: boolean): Promise<void>;
    updateSkippedDevice(bulkOperationId: string, deviceUid: string, decrementInProgress?: boolean): Promise<void>;
    updateInProgressDevice(bulkOperationId: string, deviceUid: string, updateValue: number): Promise<void>;
    updateDateRecord(bulkOperationId: string, updateObject: UpdateDateRecord): Promise<void>;
    updateIsRunning(bulkOperationId: string, updateValue: boolean): Promise<void>;
    setCurrentStatusToWaiting(bulkOperationId: string): Promise<void>;
    updateRollingUpdate(bulkOperationId: string, update: IRollingUpdate): Promise<void>;
    addDeviceToDraft(bulkOperationUid: string, deviceIdentityHashes: string[]): Promise<void>;
    finishDraft(bulkOperationUid: string): Promise<void>;
    addDeviceUids(bulkOperationUid: string, deviceUids: IDeviceUids[]): Promise<void>;
}
export interface IBulkOperationModleObservable<T extends IBulkOperationAlias> {
    observeByUid(bulkOperationUid: string): Promise<Observable<IChanges<T>, Error>>;
}
//# sourceMappingURL=bulkOperationModel.d.ts.map