"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSorting = void 0;
const paginationTypes_1 = require("../../Lib/Pagination/paginationTypes");
const pagination_1 = require("../../Lib/Pagination/pagination");
function getSorting(sorting) {
    const mapSortingField = (field) => {
        switch (field) {
            case 'scheduledAt':
                return 'schedule.datetime';
            case 'devices':
                return 'progress.total';
            default:
                return field;
        }
    };
    return (0, pagination_1.getSorting)({
        defaultSorting: {
            field: 'createdAt',
            order: paginationTypes_1.SortOrder.DESC,
        },
        sorting: sorting
            ? {
                field: mapSortingField(sorting.field),
                order: sorting.order,
            }
            : undefined,
    });
}
exports.getSorting = getSorting;
//# sourceMappingURL=bulkOperation.utils.js.map