/// <reference types="lib.es2017.observable" />
import IChanges from '../../../IChanges';
import { Sorting } from '../../../Lib/Pagination/paginationTypes';
import { IFrontDisplayVersion } from '../../FrontDisplay/Version/frontDisplayVersionModel';
import { IApplication } from '../applicationModel';
import ApplicationType from '@signageos/common-types/dist/Application/ApplicationType';
export interface ITestSuiteGroup {
    suiteType: string;
    deviceModel: string;
    firmwareVersion: string;
}
export interface ITestSuite extends ITestSuiteGroup {
    pendingTests: string[];
    passedTests: string[];
    failedTests: string[];
    startedAt: Date;
    passedAt?: Date;
    failedAt?: Date;
}
export declare type IApplicationVersion = IApplicationVersionRequired | (IApplicationVersionRequired & IApplicationVersionOptional);
export interface IApplicationVersionRequired {
    uid: any;
    application: string;
    frontDisplayVersion: string;
    version: string;
}
export interface IApplicationVersionOptional {
    supportedFirmwareTypes?: string[];
    createdAt: Date;
    description?: string;
    testSuites?: ITestSuite[];
    publishedSince?: Date;
    deprecatedSince?: Date;
}
export declare type SortField = 'createdAt' | 'versionComparable';
export interface IApplicationVersionFilter {
    /** The type of core app */
    applicationType?: ApplicationType;
    /**
     * If true, returns manually published versions.
     */
    onlyPublished?: boolean;
    /**
     * If true, returns only the not prerelease tagged semver version: 3.0.0, 5.2.1 (not 2.3.1-master.123 etc).
     * If you want to filter manually published versions, use onlyPublished.
     */
    onlyReleased?: boolean;
    /**
     * Will filter output with the only those that has the value in `supportedFirmwareTypes` property.
     * The null value is special. It will return only those that has the `supportedFirmwareTypes` property undefined/empty.
     * Those are old versions that don't specify the supported firmware types explicitly.
     */
    supportedFirmwareType?: string | null;
    /**
     * Regexp for version
     */
    search?: string;
    /**
     * Limit number of versions returned
     */
    limit?: number;
}
export declare type IApplicationVersionModel<TApplicationVersion extends IApplicationVersion> = IApplicationVersionModelRead<TApplicationVersion> & IApplicationVersionModelWrite<TApplicationVersion> & IApplicationVersionModelObservable<TApplicationVersion>;
export interface IApplicationVersionModelRead<TApplicationVersion extends IApplicationVersion> {
    fetchByUid(uid: TApplicationVersion['uid']): Promise<TApplicationVersion | null>;
    fetchByApplicationAndVersion(application: IApplication, version: string): Promise<TApplicationVersion | null>;
    /** @deprecated use fetchListByFilter instead */
    fetchListByApplication(application: string, onlyPublished?: boolean): Promise<TApplicationVersion[]>;
    /** @deprecated use fetchListByFilter instead */
    fetchAll(onlyPublished?: boolean): Promise<TApplicationVersion[]>;
    /** @deprecated use fetchLatestByFilter instead */
    fetchLatestByApplication(application: string, onlyPublished?: boolean, onlyReleased?: boolean): Promise<TApplicationVersion | null>;
    fetchListByFilter(filter: IApplicationVersionFilter, sort?: Sorting<SortField>): Promise<TApplicationVersion[]>;
    fetchLatestByFilter(filter: IApplicationVersionFilter): Promise<TApplicationVersion | null>;
    fetchListByUids(uids: string[]): Promise<TApplicationVersion[]>;
}
export interface IApplicationVersionModelWrite<TApplicationVersion extends IApplicationVersion> {
    create(application: IApplication, frontDisplayVersion: IFrontDisplayVersion, version: string, supportedFirmwareTypes: string[] | undefined, createdAt: Date): Promise<void>;
    markAsPublished(applicationVersionRow: TApplicationVersion, publishedSince: Date): Promise<void>;
    markAsDeprecated(applicationVersionRow: TApplicationVersion, deprecatedSince: Date): Promise<void>;
    markAsNotPublished(applicationVersionRow: TApplicationVersion): Promise<void>;
    markAsNotDeprecated(applicationVersionRow: TApplicationVersion): Promise<void>;
    updateDescription(applicationVersionRow: TApplicationVersion, description: string): Promise<void>;
    setTestSuite(applicationVersionRow: TApplicationVersion, suiteGroup: ITestSuiteGroup, tests: {
        pendingTests: string[];
        passedTests: string[];
        failedTests: string[];
        startedAt: Date;
    }): Promise<void>;
    setTestSuitePassed(applicationVersionRow: TApplicationVersion, suiteGroup: ITestSuiteGroup, passedAt: Date): Promise<void>;
    setTestSuiteFailed(applicationVersionRow: TApplicationVersion, suiteGroup: ITestSuiteGroup, failedAt: Date): Promise<void>;
    addTestPassed(applicationVersionRow: TApplicationVersion, suiteGroup: ITestSuiteGroup, identification: string): Promise<void>;
    addTestFailed(applicationVersionRow: TApplicationVersion, suiteGroup: ITestSuiteGroup, identification: string): Promise<void>;
}
export interface IApplicationVersionModelObservable<TAV extends IApplicationVersion> {
    observeAll(onlyPublished?: boolean): Promise<Observable<IChanges<TAV>, Error>>;
}
//# sourceMappingURL=applicationVersionModel.d.ts.map