/// <reference types="lib.es2017.observable" />
import { OffsetPagination, Sorting } from '../../../Lib/Pagination/paginationTypes';
import { IOrganization } from '../../Organization/organizationModel';
import ApplicationType from '@signageos/common-types/dist/Application/ApplicationType';
import { ApplicationVersionBuildRequestStatus } from '@signageos/common-types/dist/Application/Version/ApplicationVersionBuildRequest';
export interface IApplicationVersionBuildRequest {
    requestUid: string;
    application: {
        version: string;
        name: string;
        signature: string | null;
        flavour: string | null;
    };
    bundledApplet: {
        uid: string;
        version: string;
        name: string;
        updatedAt: Date;
        publishedSince: Date | null;
        organizationUid: string;
        organizationName: string;
        entryFile: string;
        baseUrl: string;
        files: string[];
        config: {
            [key: string]: string | string[];
        } | null;
    };
    bundledFrontApplet: {
        version: string;
        binaryFileUrl: string;
    } | null;
    autoVerification: {
        organizationUid: string;
    };
    createdAt: Date | null;
    failedAt: Date | null;
    builtSince: Date | null;
    buildUrl: string | null;
    directBuildUrl: string | null;
}
export declare type TSortField = 'application.name' | 'builtSince' | 'createdAt';
export declare type TSortLatestField = 'builtSince' | 'bundledApplet.version';
export interface ApplicationVersionBuildRequestFilter {
    organizations?: IOrganization[];
    includeByStatus?: ApplicationVersionBuildRequestStatus[];
    appletUid?: IApplicationVersionBuildRequest['bundledApplet']['uid'];
    appletVersion?: IApplicationVersionBuildRequest['bundledApplet']['version'];
    applicationType?: ApplicationType;
    builtSince?: Date;
}
export interface ApplicationVersionBuildRequestFetchListArgs {
    filter?: ApplicationVersionBuildRequestFilter;
    pagination?: OffsetPagination;
    sorting?: Sorting<TSortField>;
}
export declare type IApplicationVersionBuildRequestModel = IApplicationVersionBuildRequestModelRead & IApplicationVersionBuildRequestModeWrite & IApplicationVersionBuildRequestModelObservable;
export interface IApplicationVersionBuildRequestModelRead {
    fetchByRequestUid(requestUid: string): Promise<IApplicationVersionBuildRequest | null>;
    fetchAll(): Promise<IApplicationVersionBuildRequest[]>;
    fetchAllByApplicationType(applicationType: ApplicationType, version: string, appletUid: string, appletVersion: string, applicationSignature?: string, applicationFlavour?: string): Promise<IApplicationVersionBuildRequest[]>;
    fetchLastByApplicationType(applicationType: ApplicationType, version: string, appletUid: string, appletVersion: string, applicationSignature?: string, applicationFlavour?: string): Promise<IApplicationVersionBuildRequest | null>;
    fetchList(args: ApplicationVersionBuildRequestFetchListArgs): Promise<IApplicationVersionBuildRequest[]>;
    count(filter: ApplicationVersionBuildRequestFilter): Promise<number>;
    fetchLatestByBundledApplet(appletUid: IApplicationVersionBuildRequest['bundledApplet']['uid'], sortField: TSortLatestField): Promise<IApplicationVersionBuildRequest[]>;
    countUniqueApplicationNames(filter: ApplicationVersionBuildRequestFilter): Promise<number>;
}
export interface IApplicationVersionBuildRequestModeWrite {
    create(applicationVersionBuildRequest: IApplicationVersionBuildRequest): Promise<void>;
    markBuildSucceeded(requestUid: string, builtSince: Date, buildUrl: string, directBuildUrl: string | null): Promise<void>;
    markBuildFailed(requestUid: string, failedAt: Date): Promise<void>;
}
export interface IApplicationVersionBuildRequestModelObservable {
    observeList(args: ApplicationVersionBuildRequestFetchListArgs): Promise<Observable<IApplicationVersionBuildRequest[], Error>>;
}
//# sourceMappingURL=applicationVersionBuildRequestModel.d.ts.map