/// <reference types="lib.es2017.observable" />
import { DeviceFilter as FullDeviceFilter } from '@signageos/common-types/dist/Device/deviceFilter';
import IChanges from '../../IChanges';
import { DefaultDeviceFilter } from '../Device/deviceModel';
import { IOrganization } from '../Organization/organizationModel';
export interface IApplet {
    uid: string;
    name: string;
    createdAt: Date;
    organizationUid: string;
    iconUrl?: string | null;
}
export interface IAppletListPagination {
    offset?: number;
    limit?: number;
}
export declare enum OrderDirection {
    ASC = 1,
    DESC = -1
}
export interface IAppletListSorter {
    uid?: OrderDirection;
    name?: OrderDirection;
    createdAt?: OrderDirection;
    organizationTitle?: OrderDirection;
}
export interface IAppletPropertyFilter {
    name?: string;
    uids?: string[];
}
export interface IAppletFetchOptions {
    filter?: IAppletPropertyFilter;
    sorter?: IAppletListSorter;
    pagination?: IAppletListPagination;
}
export declare type IAppletModel<TApplet extends IApplet, TDeviceFilter extends FullDeviceFilter = DefaultDeviceFilter> = IAppletModelRead<TApplet, TDeviceFilter> & IAppletModelWrite<TApplet> & IAppletModelObservable<TApplet>;
export interface IAppletModelRead<TApplet extends IApplet, DeviceFilter extends FullDeviceFilter = DefaultDeviceFilter> {
    fetchByUid(uid: string): Promise<TApplet | null>;
    fetchListByOrganization(organization: IOrganization): Promise<TApplet[]>;
    fetchListByOrganizations(organizations: IOrganization[]): Promise<TApplet[]>;
    fetchSortedListByOrganizations(organizations: IOrganization[], options: IAppletFetchOptions): Promise<TApplet[]>;
    fetchTotalCountByOrganizations(organizations: IOrganization[], filter?: IAppletPropertyFilter): Promise<number>;
    fetchListByDeviceFilter(organizations: IOrganization[], deviceFilter?: Omit<DeviceFilter, 'appletUids'>): Promise<IApplet[]>;
    /**
     * Returns a list of applets that are common to all filtered devices, that is,
     * all devices within the filtered result are assigned the same applet.
     */
    fetchCommonListByDeviceFilter(organizations: IOrganization[], deviceFilter?: DeviceFilter): Promise<IApplet[]>;
}
export interface IAppletModelWrite<TApplet extends IApplet> {
    create(uid: string, name: string, createdAt: Date, organizationUid: string, iconUrl?: string | null): Promise<void>;
    updateName(appletRow: TApplet, name: string): Promise<void>;
    remove(appletRow: TApplet): Promise<void>;
    updateOrganization(appletRow: TApplet, organization: IOrganization): Promise<void>;
    updateIconUrl(appletRow: TApplet, iconUrl?: string | null): Promise<void>;
}
export interface IAppletModelObservable<TApplet extends IApplet> {
    observeSortedListByOrganizations(organizations: IOrganization[], options: IAppletFetchOptions): Promise<Observable<IApplet[], Error>>;
    observeByUid(uid: string): Promise<Observable<IChanges<TApplet>, Error>>;
}
//# sourceMappingURL=appletModel.d.ts.map