import { IAppletVersion } from '../Version/appletVersionModel';
export interface IAppletTestSuite {
    id: any;
    appletUid: string;
    appletVersion: string;
    identifier: string;
    binary: string;
    createdAt: Date;
    updatedAt: Date;
}
export declare type IAppletTestSuiteModel<TAppletTestSuite extends IAppletTestSuite, TAppletVersion extends IAppletVersion> = IAppletTestSuiteModelRequired<TAppletTestSuite, TAppletVersion>;
export interface IAppletTestSuiteModelRequired<TAppletTestSuite extends IAppletTestSuite, TAppletVersion extends IAppletVersion> {
    fetchOneById(id: any): Promise<TAppletTestSuite | null>;
    fetchOne(appletVersion: TAppletVersion, identifier: string): Promise<TAppletTestSuite | null>;
    fetchAllOf(appletVersion: TAppletVersion): Promise<TAppletTestSuite[] | null>;
    create(appletVersion: TAppletVersion, identifier: string, binary: string, createdAt: Date): Promise<void>;
    update(appletTestSuiteRow: TAppletTestSuite, binary: string, updatedAt: Date): Promise<void>;
    remove(appletTestSuiteRow: TAppletTestSuite): Promise<void>;
}
//# sourceMappingURL=appletTestSuiteModel.d.ts.map