import { IAccount } from './accountModel';
export interface IApiSecurityToken {
    /** Identification which can be used to find account or api security token faster */
    id: string;
    token: string;
    salt: string;
    name?: string;
    createdAt?: Date;
    version: number;
    organizationUid?: string;
}
export interface IAccountSettings {
    accountId: number;
    timezone?: string;
    apiSecurityTokens: IApiSecurityToken[];
    passwordSecurity?: {
        token: string;
        createdAt: Date;
    };
    email: {
        notificationAlertLevels: ('info' | 'warning' | 'error')[];
        isSubscribedToNewsletter: boolean;
    };
    welcomeDashboard?: {
        sectionsAppearance: {
            [key: string]: string;
        };
    };
}
export declare type IAccountSettingsModel<TS extends IAccountSettings, T extends IAccount> = IAccountSettingsModelRead<TS, T> & IAccountSettingsModelWrite<TS>;
export interface IAccountSettingsModelRead<TAccountSettings extends IAccountSettings, TAccount extends IAccount> {
    fetchByAccount(account: TAccount): Promise<TAccountSettings | null>;
    fetchByApiSecurityTokenId(id: string): Promise<TAccountSettings | null>;
}
export interface IAccountSettingsModelWrite<TAccountSettings extends IAccountSettings> {
    create(accountId: number): Promise<void>;
    updateTimezone(accountSettingsRow: TAccountSettings, timezone: string): Promise<void>;
    addApiSecurityToken(accountSettingsRow: TAccountSettings, apiSecurityToken: IApiSecurityToken): Promise<void>;
    removeApiSecurityToken(accountSettingsRow: TAccountSettings, id: string): Promise<void>;
    clearApiSecurityTokens(accountSettingsRow: TAccountSettings): Promise<void>;
    updatePasswordSecurityTokenAndDate(accountSettingsRow: TAccountSettings, passwordSecurityToken: string, createdAt: Date): Promise<void>;
    invalidatePasswordSecurityToken(accountSettingsRow: TAccountSettings): Promise<void>;
    updateEmailNotificationsAlertLevel(accountSettingsRow: TAccountSettings, alertLevels: ('info' | 'warning' | 'error')[]): Promise<void>;
    updateEmailNotificationsNewsletter(accountSettingsRow: TAccountSettings, isSubscribedToNewsletter: boolean): Promise<void>;
    updateWelcomeDashboardSectionsAppearance(accountSettingsRow: TAccountSettings, sectionsAppearance: {
        [key: string]: string;
    }): Promise<void>;
}
//# sourceMappingURL=accountSettingsModel.d.ts.map