"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPolicyLogModel = void 0;
const _ = require("lodash");
const helper_1 = require("../helper");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const policyLogUidKeyPrefix = 'policyLog.uid';
function getPolicyLogUidKey(uid) {
    return `${policyLogUidKeyPrefix}.${uid}`;
}
const policyLogOrganizationUidKeyPrefix = 'policyLog.organizationUid';
function getPolicyLogOrganizationUidKey(organizationUid) {
    return `${policyLogOrganizationUidKeyPrefix}.${organizationUid}`;
}
const createPolicyLogModel = (conn, sourceModel) => {
    function updatePolicyLogPartial(policyLogPartial) {
        return __awaiter(this, void 0, void 0, function* () {
            const policyLogUidOnly = _.pick(policyLogPartial, 'uid');
            yield (0, helper_1.updatePartialOne)(conn, getPolicyLogUidKey(policyLogPartial.uid), policyLogUidOnly);
            yield (0, helper_1.updatePartialOne)(conn, getPolicyLogOrganizationUidKey(policyLogPartial.organizationUid), policyLogUidOnly);
        });
    }
    function observePolicyLog(policyLogKey) {
        const observable = (0, helper_1.observe)(conn, policyLogKey);
        return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            const policyLog = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield sourceModel.fetchLatestByUid(changes.new_partial_val.uid);
            }));
            return {
                old_val: { uid: changes.new_partial_val.uid },
                new_val: policyLog,
                clusterTime: changes.clusterTime,
            };
        }));
    }
    function computePolicyLogsStamp(policyLogs) {
        return policyLogs.reduce((stamp, policyLog, index) => {
            return stamp + (1 - 2 * (index % 2)) * policyLog.updatedAt.getTime();
        }, 0);
    }
    return {
        observeLatestListByUids(uids) {
            return __awaiter(this, void 0, void 0, function* () {
                return (0, helpers_1.mergeObservables)(...uids.map((uid) => observePolicyLog(getPolicyLogUidKey(uid))));
            });
        },
        observeLatestListByOrganizations(organizations, archived, inputSorter, limit, offset, name, statusFilter) {
            return __awaiter(this, void 0, void 0, function* () {
                const grainObservable = (0, helpers_1.mergeObservables)(...organizations.map(({ uid }) => (0, helper_1.observe)(conn, getPolicyLogOrganizationUidKey(uid))));
                const sorter = inputSorter ? (inputSorter instanceof Array ? inputSorter : [inputSorter]) : undefined;
                // When notification about any policy assigned to one of chosen organizations is recevied the query with same parameters
                // as original is executed and only if its stamp is different from last saved stamp loaded data will be propagated.
                let lastStamp = Math.round(Math.random() * 1e6);
                const fineObservable = (0, helpers_1.asyncMap)(grainObservable, (_changes) => __awaiter(this, void 0, void 0, function* () {
                    return yield sourceModel.fetchLatestListByOrganizations(organizations, archived, sorter, limit, offset, name, undefined, statusFilter);
                })).filter((policyLogs) => {
                    const currentStamp = computePolicyLogsStamp(policyLogs);
                    if (currentStamp !== lastStamp) {
                        lastStamp = currentStamp;
                        return true;
                    }
                    return false;
                });
                return fineObservable;
            });
        },
        observeLatestByUid(uid) {
            return __awaiter(this, void 0, void 0, function* () {
                return observePolicyLog(getPolicyLogUidKey(uid));
            });
        },
        create(uid, _name, organizationUid, _createdAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updatePolicyLogPartial({ uid, organizationUid });
            });
        },
        clone(_policyLogRow, uid, _name, organizationUid, _createdAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updatePolicyLogPartial({ uid, organizationUid });
            });
        },
        updateItems(policyLogRow, _items, _updatedAt, _originator, _note) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updatePolicyLogPartial({ uid: policyLogRow.uid, organizationUid: policyLogRow.organizationUid });
            });
        },
        updateName(policyLogRow, _name, _updatedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updatePolicyLogPartial({ uid: policyLogRow.uid, organizationUid: policyLogRow.organizationUid });
            });
        },
        archive(policyLogRow, _updatedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updatePolicyLogPartial({ uid: policyLogRow.uid, organizationUid: policyLogRow.organizationUid });
            });
        },
        unarchive(policyLogRow, _updatedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updatePolicyLogPartial({ uid: policyLogRow.uid, organizationUid: policyLogRow.organizationUid });
            });
        },
        remove(policyLogRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updatePolicyLogPartial({ uid: policyLogRow.uid, organizationUid: policyLogRow.organizationUid });
            });
        },
    };
};
exports.createPolicyLogModel = createPolicyLogModel;
//# sourceMappingURL=policyLogModel.js.map