"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModelDeletable = void 0;
const helper_1 = require("../../helper");
/**
 * Create a full deletable model of an entity
 */
function createModelDeletable({ keysBuilder, conn, }) {
    return {
        delete(uid) {
            return __awaiter(this, void 0, void 0, function* () {
                for (const key of keysBuilder(uid)) {
                    yield (0, helper_1.deleteOne)(conn, key);
                }
            });
        },
        deleteMany(uids) {
            return __awaiter(this, void 0, void 0, function* () {
                for (const uid of uids) {
                    for (const key of keysBuilder(uid)) {
                        yield (0, helper_1.deleteOne)(conn, key);
                    }
                }
            });
        },
    };
}
exports.createModelDeletable = createModelDeletable;
//# sourceMappingURL=modelDeletable.js.map