import { IRedisConnection } from '@signageos/lib/dist/Redis/redisConnectionFactory';
import { IModelCreatable } from '../../../Lib/Model/IModelCreatable';
import { IModelUpdatable } from '../../../Lib/Model/IModelUpdatable';
import { ICreatable, IEntity, IUpdatable } from '../../../Lib/Model/model';
import { IModelDeletable } from '../../../Lib/Model/IModelDeletable';
export declare type CreateModelProps<TEntity extends IEntity> = {
    keysBuilder: (entity: TEntity['uid']) => string[];
    removedKeysBuilder: (entity: TEntity['uid']) => string[];
    conn: IRedisConnection;
};
declare type FullEntity = IEntity & ICreatable & IUpdatable;
export declare type CreateModelReturnType<TEntity extends IEntity, TFullEntity extends TEntity & FullEntity> = IModelCreatable<TFullEntity> & IModelUpdatable<TEntity> & IModelDeletable<TEntity>;
/**
 * Creates a full creatable, updatable and deletable model for an entity
 */
export declare function createModel<TEntity extends IEntity, TFullEntity extends TEntity & FullEntity>({ keysBuilder, removedKeysBuilder, conn, }: CreateModelProps<TEntity>): CreateModelReturnType<TEntity, TFullEntity>;
export {};
//# sourceMappingURL=model.d.ts.map