"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFrontDisplayVersionModel = void 0;
const helper_1 = require("../../helper");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const frontDisplayVersionAllKey = 'frontDisplayVersion.all';
const createFrontDisplayVersionModel = (conn, sourceModel) => {
    function updateFrontDisplayVersionPartial(frontDisplayVersionPartial) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, frontDisplayVersionAllKey, frontDisplayVersionPartial);
        });
    }
    function observeFrontDisplayVersion(frontDisplayVersionKey) {
        const observable = (0, helper_1.observe)(conn, frontDisplayVersionKey);
        return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            const frontDisplayVersion = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield sourceModel.fetchByVersion(changes.new_partial_val.version);
            }));
            if (!frontDisplayVersion) {
                throw new Error(`Front display version doesn't exist`);
            }
            return {
                old_val: frontDisplayVersion,
                new_val: frontDisplayVersion,
                clusterTime: changes.clusterTime,
            };
        }));
    }
    return {
        create(version, _createdAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateFrontDisplayVersionPartial({
                    version,
                });
            });
        },
        setTestSuite(frontDisplayVersionRow, _suiteGroup, _tests) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateFrontDisplayVersionPartial({
                    version: frontDisplayVersionRow.version,
                });
            });
        },
        setTestSuitePassed(frontDisplayVersionRow, _suiteGroup, _passedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateFrontDisplayVersionPartial({
                    version: frontDisplayVersionRow.version,
                });
            });
        },
        setTestSuiteFailed(frontDisplayVersionRow, _suiteGroup, _passedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateFrontDisplayVersionPartial({
                    version: frontDisplayVersionRow.version,
                });
            });
        },
        addTestPassed(frontDisplayVersionRow, _suiteGroup, _identification) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateFrontDisplayVersionPartial({
                    version: frontDisplayVersionRow.version,
                });
            });
        },
        addTestFailed(frontDisplayVersionRow, _suiteGroup, _identification) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateFrontDisplayVersionPartial({
                    version: frontDisplayVersionRow.version,
                });
            });
        },
        observeAll() {
            return __awaiter(this, void 0, void 0, function* () {
                return observeFrontDisplayVersion(frontDisplayVersionAllKey);
            });
        },
    };
};
exports.createFrontDisplayVersionModel = createFrontDisplayVersionModel;
//# sourceMappingURL=frontDisplayVersionModel.js.map