"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createConsumedEventModel = void 0;
const databases_1 = require("../databases");
const helper_1 = require("../helper");
const DAY_IN_SECONDS = 24 * 60 * 60;
function getKey(domainName, eventId) {
    return `consumedEvent.${domainName}.${eventId}`;
}
const createConsumedEventModel = (generalConn) => {
    const conn = generalConn.getDB(databases_1.Database.EVENT_SOURCING);
    return {
        create(domainName, eventId, eventType, consumedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                const consumedEvent = {
                    domainName,
                    eventId,
                    eventType,
                    consumedAt,
                };
                const key = getKey(domainName, eventId);
                yield (0, helper_1.createOne)(conn, key, consumedEvent);
                yield (0, helper_1.setExpiration)(conn, key, DAY_IN_SECONDS);
            });
        },
        fetchByDomainNameAndEventId(domainName, eventId) {
            return __awaiter(this, void 0, void 0, function* () {
                return yield (0, helper_1.getOne)(conn, getKey(domainName, eventId));
            });
        },
    };
};
exports.createConsumedEventModel = createConsumedEventModel;
//# sourceMappingURL=consumedEventModel.js.map