"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceModel = void 0;
const _ = require("lodash");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const helper_1 = require("../helper");
const deviceConnectionModel_1 = require("./Connection/deviceConnectionModel");
const deviceIdentityHashKeyPrefix = 'device.identityHash';
function getDeviceIdentityHashKey(identityHash) {
    return `${deviceIdentityHashKeyPrefix}.${identityHash}`;
}
const deviceUidKeyPrefix = 'device.uid';
function getDeviceUidKey(uid) {
    return `${deviceUidKeyPrefix}.${uid}`;
}
const deviceAccountIdKeyPrefix = 'device.accountId';
function getDeviceAccountIdKey(accountId) {
    return `${deviceAccountIdKeyPrefix}.${accountId}`;
}
const deviceOrganizationUidKeyPrefix = 'device.organizationUid';
function getDeviceOrganizationUidKey(organizationUid) {
    return `${deviceOrganizationUidKeyPrefix}.${organizationUid}`;
}
const createDeviceModel = (conn, sourceModel) => {
    const deviceConnectionModel = (0, deviceConnectionModel_1.createDeviceConnectionModel)(conn);
    function updateDevicePartial(devicePartial) {
        return __awaiter(this, void 0, void 0, function* () {
            const deviceUidOnly = _.pick(devicePartial, 'uid');
            yield (0, helper_1.updatePartialOne)(conn, getDeviceUidKey(devicePartial.uid), deviceUidOnly);
            yield (0, helper_1.updatePartialOne)(conn, getDeviceIdentityHashKey(devicePartial.identityHash), deviceUidOnly);
            if (devicePartial.accountId) {
                yield (0, helper_1.updatePartialOne)(conn, getDeviceAccountIdKey(devicePartial.accountId), deviceUidOnly);
            }
            if (devicePartial.organizationUid) {
                yield (0, helper_1.updatePartialOne)(conn, getDeviceOrganizationUidKey(devicePartial.organizationUid), deviceUidOnly);
            }
        });
    }
    function observeDevice(deviceKey) {
        const observable = (0, helper_1.observe)(conn, deviceKey);
        return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            const device = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield sourceModel.fetchByUid(changes.new_partial_val.uid);
            }));
            return {
                old_val: { uid: changes.new_partial_val.uid },
                new_val: device,
                clusterTime: changes.clusterTime,
            };
        }));
    }
    function updateDeviceRow(deviceRow) {
        return __awaiter(this, void 0, void 0, function* () {
            yield updateDevicePartial({
                uid: deviceRow.uid,
                identityHash: deviceRow.identityHash,
                accountId: deviceRow.accountId || null,
                organizationUid: deviceRow.organizationUid || null,
            });
        });
    }
    return {
        observeListByIdentityHashes(identityHashes) {
            return __awaiter(this, void 0, void 0, function* () {
                return (0, helpers_1.mergeObservables)(...identityHashes.map((identityHash) => observeDevice(getDeviceIdentityHashKey(identityHash))));
            });
        },
        observeListByAccount(account, ignoreOrganizations = false) {
            return __awaiter(this, void 0, void 0, function* () {
                const observable = observeDevice(getDeviceAccountIdKey(account.id));
                return observable
                    .filter((changes) => {
                    var _a;
                    return ignoreOrganizations ? !((_a = changes.new_val) === null || _a === void 0 ? void 0 : _a.organizationUid) : true;
                })
                    .map((changes) => {
                    var _a;
                    return ((_a = changes.new_val) === null || _a === void 0 ? void 0 : _a.accountId) === account.id
                        ? changes
                        : Object.assign(Object.assign({}, changes), { new_val: null });
                });
            });
        },
        observeByIdentityHash(identityHash) {
            return __awaiter(this, void 0, void 0, function* () {
                return observeDevice(getDeviceIdentityHashKey(identityHash));
            });
        },
        create(uid, identityHash, _application, _createdAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDevicePartial({
                    uid,
                    identityHash,
                    accountId: null,
                    organizationUid: null,
                });
            });
        },
        updateModel(deviceRow, _model) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        updateSerialNumber(deviceRow, _serialNumber) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        updateBrand(deviceRow, _brand) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        updateOSVersion(deviceRow, _osVersion) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        updateName(deviceRow, _name) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        updateExtendedManagementSince(deviceRow, _extendedManagementSince) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        updateExtendedManagementPairCode(deviceRow, _extendedManagementPairCode) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        updateAccount(deviceRow, account) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDevicePartial({
                    uid: deviceRow.uid,
                    identityHash: deviceRow.identityHash,
                    accountId: account.id,
                    organizationUid: deviceRow.organizationUid || null,
                });
            });
        },
        removeAccount(deviceRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        updateOrganization(deviceRow, organization) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDevicePartial({
                    uid: deviceRow.uid,
                    identityHash: deviceRow.identityHash,
                    accountId: deviceRow.accountId || null,
                    organizationUid: organization.uid,
                });
                yield deviceConnectionModel.updateDeviceOrganization(deviceRow, organization.uid);
            });
        },
        removeOrganization(deviceRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
                yield deviceConnectionModel.updateDeviceOrganization(deviceRow, null);
            });
        },
        updatePinCode(deviceRow, _pinCode) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        updateFirmwareType(deviceRow, _firmwareType) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        updateFirmwareVersion(deviceRow, _firmwareVersion) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        markBanned(deviceRow, _bannedSince) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        markApproved(deviceRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        changeSubscriptionType(deviceRow, _subscriptionType) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        assignTag(deviceRow, _tagUid) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        removeTag(deviceRow, _tagUid) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        assignOrUpdatePolicy(deviceRow, _policy) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        removePolicy(deviceRow, _policy) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        setLastProvisionedAt(deviceRow, _provisionedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        setFirstProvisionedAt(deviceRow, _provisionedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        setLastDeprovisionedAt(deviceRow, _deprovisionedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        assignDeviceToLocation(deviceRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
        unassignDeviceFromLocation(deviceRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateDeviceRow(deviceRow);
            });
        },
    };
};
exports.createDeviceModel = createDeviceModel;
//# sourceMappingURL=deviceModel.js.map