"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceTimeoutModel = void 0;
const helper_1 = require("../../helper");
const TTL_SECONDS = 7 * 24 * 60 * 60; // expire timeout after 7 days of not connecting
function getActionDeliveryTimeoutDeviceKey(duid) {
    return `deviceTimeout_actionDelivery_${duid}`;
}
const createDeviceTimeoutModel = (conn) => ({
    fetchActionDeliveryTimeout(duid) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield (0, helper_1.getOne)(conn, getActionDeliveryTimeoutDeviceKey(duid));
        });
    },
    setActionDeliveryTimeout(duid, actionDeliveryTimeoutMs) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.createOneWithExpiration)(conn, getActionDeliveryTimeoutDeviceKey(duid), actionDeliveryTimeoutMs, TTL_SECONDS);
        });
    },
    removeActionDeliveryTimeout(duid) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.deleteOne)(conn, getActionDeliveryTimeoutDeviceKey(duid));
        });
    },
});
exports.createDeviceTimeoutModel = createDeviceTimeoutModel;
//# sourceMappingURL=deviceTimeoutModel.js.map